/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class GrandswordItem
extends MimicryItem {
    public GrandswordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        if (ticksUsed > 8 && 50 >= ticksUsed) {
            this.jump((LivingEntity)player, 0.65f, 0.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0));
            if (ticksUsed % 10 != 0) {
                return;
            }
            List<LivingEntity> enemies = this.spinAttack(player, 4.0f);
            float damage = mimicryAttributes.getGrandswordDamage();
            enemies.forEach(target -> {
                GrandswordItem.breakShield(target);
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, mimicryAttributes.getGrandswordEffectTime(), 0));
                this.knockback(player, (LivingEntity)target, mimicryAttributes.getGrandswordKnockback());
            });
        }
        if (ticksUsed >= 60) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableGrandswordVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.grandsword");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.grandsword.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.grandsword.tooltip2").m_6270_(this.textStyle));
    }
}

