/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class BackhandBladeItem
extends MimicryItem {
    public BackhandBladeItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        if (ticksUsed > 2 && 9 >= ticksUsed) {
            this.jump((LivingEntity)player, 3.0f, 0.0f);
            List<LivingEntity> enemies = this.sweepAttack(player, 2.0f);
            float damage = mimicryAttributes.getBackhandBladeDamage();
            enemies.forEach(target -> {
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, mimicryAttributes.getBackhandBladeEffectTime(), 0));
            });
        }
        if (ticksUsed > 10 && 16 >= ticksUsed) {
            this.jump((LivingEntity)player, -3.0f, 0.0f);
        }
        if (ticksUsed >= 18) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableBackhandBladeVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.backhand_blade");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.backhand_blade.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.backhand_blade.tooltip2").m_6270_(this.textStyle));
    }
}

