/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.joke;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.item.normal.SimplyMoreSwordItem;
import net.sweenus.simplyswords.util.HelperMethods;

public class ThePanItem
extends SimplyMoreSwordItem {
    String[] repairIngredient = new String[]{"minecraft:iron_ingot"};
    static WrapperConfig config = (WrapperConfig)AutoConfig.getConfigHolder(WrapperConfig.class).getConfig();
    protected static UniqueEffectConfig effect = ThePanItem.config.uniqueEffects;

    public ThePanItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings, new String[0]);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        double deltaZ;
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker.m_217043_().m_216332_(1, 100) > effect.getPanBonkChance()) {
            return super.m_7579_(stack, target, attacker);
        }
        Vec3 targetPosition = target.m_20182_();
        Vec3 attackerPosition = attacker.m_20182_();
        double deltaX = targetPosition.m_7096_() - attackerPosition.m_7096_();
        double distance = Math.hypot(deltaX, deltaZ = targetPosition.m_7094_() - attackerPosition.m_7094_());
        if (distance == 0.0) {
            return super.m_7579_(stack, target, attacker);
        }
        float knockbackStrength = effect.getPanBonkStrength();
        double normalizedDeltaX = deltaX / distance;
        double normalizedDeltaZ = deltaZ / distance;
        target.m_20334_(normalizedDeltaX * (double)knockbackStrength, 0.2, normalizedDeltaZ * (double)knockbackStrength);
        target.f_19864_ = true;
        attacker.m_9236_().m_5594_(null, attacker.m_20183_(), SoundEvents.f_11669_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        ArrayList potentialIngredients = new ArrayList(List.of());
        Arrays.stream(this.repairIngredient).toList().forEach(repIngredient -> potentialIngredients.add((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(repIngredient))));
        return potentialIngredients.contains(ingredient.m_41720_());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.the_pan.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.the_pan.tooltip2").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

