/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.entity.VipersCallProjectileAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class VipersCallItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getVipersCallCooldown();
    public String[] effectBlacklist = new String[]{"simplyswords:fatal_flicker", "minecraft:absorption", "simplyswords:flameseed", "simplyswords:frenzy"};
    int stepMod = 0;

    public VipersCallItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().f_46443_) {
            VipersCallProjectileAreaEffectCloudEntity chakram = new VipersCallProjectileAreaEffectCloudEntity(user.m_9236_(), user.m_20185_(), user.m_20188_() - 0.6, user.m_20189_(), (LivingEntity)user);
            user.m_9236_().m_7967_((Entity)chakram);
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
            user.m_9236_().m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.DARK_SWORD_WHOOSH_02.get(), user.m_5720_(), 2.0f, 1.0f);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (world.m_46467_() % 20L == 0L && entity instanceof Player && (player = (Player)entity).m_21120_(InteractionHand.MAIN_HAND).equals(stack)) {
            for (MobEffectInstance effect : player.m_21220_()) {
                if (effect.m_19557_() >= 25 || this.isInBlacklist(effect)) continue;
                player.m_7292_(new MobEffectInstance(effect.m_19544_(), 25, 0));
            }
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    private boolean isInBlacklist(MobEffectInstance effect) {
        ArrayList blacklistedEffects = new ArrayList(List.of());
        Arrays.stream(this.effectBlacklist).toList().forEach(effectType -> blacklistedEffects.add((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectType))));
        return blacklistedEffects.contains(effect.m_19544_());
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.vipers_call.tooltip8").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

