/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class TimekeeperItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getTimekeeperBaseCooldown();
    int stepMod = 0;

    public TimekeeperItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world.f_46443_) {
            return super.m_7203_(world, user, hand);
        }
        double playerX = user.m_20185_();
        double playerY = user.m_20188_();
        double playerZ = user.m_20189_();
        long currentTime = Math.abs(world.m_46468_() % 24000L);
        boolean isFixedTime = world.m_6042_().m_63967_();
        if (!isFixedTime) {
            if (currentTime < 13000L) {
                this.spawnFlameAttack(world, user, playerX, playerY, playerZ);
            } else {
                this.spawnWindAttack(world, user, playerX, user.m_20186_(), playerZ);
            }
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.calculateCooldown(currentTime, isFixedTime));
        }
        return super.m_7203_(world, user, hand);
    }

    private void spawnFlameAttack(Level world, Player player, double playerX, double playerY, double playerZ) {
        for (int i = 0; i < 12; ++i) {
            float yaw = (float)Math.toRadians(player.m_146908_() + 90.0f);
            float pitch = (float)Math.toRadians(player.m_146909_());
            double distanceX = Math.cos(yaw) * Math.cos(pitch) * (double)i;
            double distanceZ = Math.sin(yaw) * Math.cos(pitch) * (double)i;
            double distanceY = Math.sin(pitch) * (double)(-i);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123744_, playerX + distanceX / 2.0, playerY + distanceY / 2.0, playerZ + distanceZ / 2.0, 10, 0.3, 0.3, 0.3, 0.0);
            AABB box = new AABB(playerX + distanceX / 2.0 - 0.8, playerY + distanceY / 2.0 - 0.8, playerZ + distanceZ / 2.0 - 0.8, playerX + distanceX / 2.0 + 0.8, playerY + distanceY / 2.0 + 0.8, playerZ + distanceZ / 2.0 + 0.8);
            List entities = world.m_45976_(LivingEntity.class, box);
            for (LivingEntity entity : entities) {
                if (entity.m_7307_((Entity)player) || entity == player) continue;
                entity.m_20334_(distanceX * 2.5 / (double)i, distanceY * 2.5 / (double)i, distanceZ * 2.5 / (double)i);
                entity.f_19864_ = true;
                entity.m_20254_(5);
                entity.m_6469_(player.m_269291_().m_269549_(), effect.getTimekeeperDayActiveDamage());
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effect.getTimekeeperDayActiveBlindnessTime()));
            }
        }
        world.m_6263_(null, playerX, playerY, playerZ, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_FIRE_ATTACK_01.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void spawnWindAttack(Level world, Player player, double playerX, double playerY, double playerZ) {
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 15; ++i) {
                double yaw = Math.toRadians(player.m_146908_());
                double distanceZ = Math.cos(yaw += Math.toRadians((j - 2) * 30)) * (double)i;
                double distanceX = Math.sin(yaw) * (double)(-i);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123766_, playerX + distanceX / 2.0, playerY + 0.3, playerZ + distanceZ / 2.0, 1, 0.0, 0.0, 0.0, 0.0);
                AABB box = new AABB(playerX + distanceX / 2.0 - 0.8, playerY + 0.3 - 5.0, playerZ + distanceZ / 2.0 - 0.8, playerX + distanceX / 2.0 + 0.8, playerY + 0.3 + 5.0, playerZ + distanceZ / 2.0 + 0.8);
                List entities = world.m_45976_(LivingEntity.class, box);
                for (LivingEntity entity : entities) {
                    if (entity.m_7307_((Entity)player) || entity == player) continue;
                    entity.m_20334_(0.0, 1.5, 0.0);
                    entity.f_19864_ = true;
                    entity.m_6469_(player.m_269291_().m_269425_(), effect.getTimekeeperNightActiveDamage());
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effect.getTimekeeperNightActiveSlownessTime(), 3));
                }
            }
        }
        world.m_6263_(null, playerX, playerY, playerZ, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_WIND_ATTACK_01.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
    }

    private int calculateCooldown(long currentTime, boolean isFixedTime) {
        return isFixedTime && currentTime < 13000L ? (int)((long)this.skillCooldown + (long)this.skillCooldown * Math.abs(6000L - currentTime) / 7000L) : (int)((long)this.skillCooldown + (long)this.skillCooldown * Math.abs(18000L - currentTime) / 7000L);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_216332_(1, 100) <= effect.getTimekeeperOnHitChance()) {
            long dayTime = Math.abs(attacker.m_9236_().m_46468_() % 24000L);
            boolean isFixedTime = attacker.m_9236_().m_6042_().m_63967_();
            if (isFixedTime) {
                this.applyRandomEffect(attacker, (ServerLevel)attacker.m_9236_());
            } else {
                this.applyTimeBasedEffect(dayTime, attacker, (ServerLevel)attacker.m_9236_());
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    private void applyDayPassiveEffect(LivingEntity attacker, ServerLevel world) {
        world.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_BLOCK_01.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_175830_, attacker.m_20185_(), attacker.m_20186_() + 0.5, attacker.m_20189_(), 20, 0.7, 0.7, 0.7, 0.0);
        for (LivingEntity passiveTarget : attacker.m_9236_().m_45976_(LivingEntity.class, new AABB(attacker.m_20185_() - 30.0, attacker.m_20186_() - 30.0, attacker.m_20189_() - 30.0, attacker.m_20185_() + 30.0, attacker.m_20186_() + 30.0, attacker.m_20189_() + 30.0))) {
            if (passiveTarget == attacker || passiveTarget.m_7307_((Entity)attacker)) continue;
            passiveTarget.m_147207_(new MobEffectInstance(MobEffects.f_19619_, effect.getTimekeeperDayPassiveEffectTime(), 0), (Entity)attacker);
        }
    }

    private void applyNightPassiveEffect(LivingEntity attacker, ServerLevel world) {
        world.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_BLOCK_01.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123765_, attacker.m_20185_(), attacker.m_20186_() + 0.5, attacker.m_20189_(), 20, 0.7, 0.7, 0.7, 0.0);
        for (LivingEntity passiveTarget : attacker.m_9236_().m_45976_(LivingEntity.class, new AABB(attacker.m_20185_() - 10.0, attacker.m_20186_() - 10.0, attacker.m_20189_() - 10.0, attacker.m_20185_() + 10.0, attacker.m_20186_() + 10.0, attacker.m_20189_() + 10.0))) {
            if (passiveTarget == attacker || passiveTarget.m_7307_((Entity)attacker)) continue;
            passiveTarget.m_147207_(new MobEffectInstance(MobEffects.f_216964_, effect.getTimekeeperNightPassiveEffectTime(), 0), (Entity)attacker);
        }
        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19609_, effect.getTimekeeperNightPassiveEffectTime(), 0), (Entity)attacker);
        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, effect.getTimekeeperNightPassiveEffectTime(), 1), (Entity)attacker);
    }

    private void applyRandomEffect(LivingEntity entity, ServerLevel world) {
        if (entity.m_217043_().m_188499_()) {
            this.applyDayPassiveEffect(entity, world);
        } else {
            this.applyNightPassiveEffect(entity, world);
        }
    }

    private void applyTimeBasedEffect(long timeOfDay, LivingEntity entity, ServerLevel world) {
        if (timeOfDay < 13000L) {
            this.applyDayPassiveEffect(entity, world);
        } else {
            this.applyNightPassiveEffect(entity, world);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        if (world == null) {
            return;
        }
        long dayTime = Math.abs(world.m_46468_() % 24000L);
        boolean isFixedTime = world.m_6042_().m_63967_();
        if (isFixedTime) {
            this.appendFixedTimeTooltips(tooltip, abilityStyle, textStyle);
        } else if (dayTime < 13000L) {
            this.appendDayTooltips(tooltip, rightClickStyle, abilityStyle, textStyle);
        } else {
            this.appendNightTooltips(tooltip, rightClickStyle, abilityStyle, textStyle);
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }

    private void appendFixedTimeTooltips(List<Component> tooltip, Style abilityStyle, Style textStyle) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_timeless.tooltip8").m_6270_(textStyle));
    }

    private void appendDayTooltips(List<Component> tooltip, Style rightClickStyle, Style abilityStyle, Style textStyle) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_day.tooltip9").m_6270_(textStyle));
    }

    private void appendNightTooltips(List<Component> tooltip, Style rightClickStyle, Style abilityStyle, Style textStyle) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.timekeeper_night.tooltip9").m_6270_(textStyle));
    }
}

