/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class TidebreakerItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getTidebreakerInsanityTeleportCooldown();
    int lastHitTime;
    LivingEntity lastHit;
    int stepMod = 0;

    public TidebreakerItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            if (attacker.m_217043_().m_216332_(1, 100) <= effect.getTidebreakerInsanityCloudChance() && !attacker.m_21023_((MobEffect)ModEffectsRegistry.TIDEBREAKER.get())) {
                attacker.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.TIDEBREAKER.get(), effect.getTidebreakerInsanityCloudDuration(), 0), (Entity)attacker);
            }
            this.lastHitTime = 0;
            this.lastHit = target;
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_9236_().m_5776_()) {
            return super.m_7203_(world, user, hand);
        }
        if (this.lastHit == null || !this.lastHit.m_6084_() || this.lastHit.m_9236_() != user.m_9236_() || this.lastHit.m_20270_((Entity)user) > (float)effect.getTidebreakerInsanityTeleportMaxDistance()) {
            return super.m_7203_(world, user, hand);
        }
        if (this.shouldTeleport(user, this.lastHit)) {
            this.swapUserAndTarget(user, this.lastHit);
            this.resetLastHit();
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
        return super.m_7203_(world, user, hand);
    }

    private boolean shouldTeleport(Player user, LivingEntity target) {
        return target.m_9236_() == user.m_9236_() && target.m_20270_((Entity)user) <= (float)effect.getTidebreakerInsanityTeleportMaxDistance();
    }

    private void swapUserAndTarget(Player user, LivingEntity target) {
        Level world = user.m_9236_();
        ServerLevel serverWorld = (ServerLevel)world;
        double targetX = target.m_20185_();
        double targetY = target.m_20186_();
        double targetZ = target.m_20189_();
        double userX = user.m_20185_();
        double userY = user.m_20186_();
        double userZ = user.m_20189_();
        user.m_20324_(targetX, targetY, targetZ);
        target.m_20324_(userX, userY, userZ);
        world.m_6263_(null, targetX, targetY, targetZ, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_02.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        world.m_6263_(null, userX, userY, userZ, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_02.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, targetX, targetY, targetZ, 300, 2.0, 0.0, 2.0, 0.0);
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, userX, userY, userZ, 300, 2.0, 0.0, 2.0, 0.0);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_) {
            ++this.lastHitTime;
            if (this.lastHitTime > effect.getTidebreakerInsanityTeleportMaxTime()) {
                this.resetLastHit();
            }
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123795_, ParticleTypes.f_123795_, ParticleTypes.f_123804_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.tidebreaker.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.tidebreaker.tooltip7", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(effect.getTidebreakerInsanityTeleportMaxTime()), effect.getTidebreakerInsanityTeleportMaxDistance()}).m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }

    private void resetLastHit() {
        this.lastHit = null;
    }
}

