/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class TheBloodHarvesterItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getHarvesterCooldown();
    int stepMod = 0;

    public TheBloodHarvesterItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && !(target instanceof ArmorStand)) {
            if (!attacker.m_21023_((MobEffect)ModEffectsRegistry.HARVEST.get())) {
                attacker.m_5634_(this.m_43299_() * effect.getHarvesterLifesteal());
            } else {
                attacker.m_5634_(this.m_43299_() * effect.getHarvesterHarvestLifesteal());
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effect.getHarvesterBleedTime(), 0));
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().f_46443_) {
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.HARVEST.get(), effect.getHarvesterHarvestTime(), 0));
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123784_, user.m_20185_(), user.m_20186_() + 0.5, user.m_20189_(), 500, 0.5, 0.5, 0.5, 0.25);
            user.m_9236_().m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), user.m_5720_(), 2.0f, 0.0f);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123802_, ParticleTypes.f_123802_, ParticleTypes.f_123784_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.the_blood_harvester.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.the_blood_harvester.tooltip2", (Object[])new Object[]{SimplyMoreHelperMethods.toPercentage(effect.getHarvesterLifesteal())}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.the_blood_harvester.tooltip3", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(effect.getHarvesterHarvestTime())}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.the_blood_harvester.tooltip4", (Object[])new Object[]{SimplyMoreHelperMethods.toPercentage(effect.getHarvesterHarvestLifesteal())}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.the_blood_harvester.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.the_blood_harvester.tooltip6").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

