/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class StasisItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getStasisLightningCooldown();
    int onHitCooldown = effect.getStasisStagnationTime();
    int stepMod = 0;

    public StasisItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_216332_(1, 100) <= effect.getStasisStagnationChance()) {
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12521_, SoundSource.PLAYERS, 0.5f, 2.0f);
            ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175830_, attacker.m_20185_(), attacker.m_20186_() + 0.5, attacker.m_20189_(), 50, 0.15, 0.25, 0.15, 0.1);
            if (target instanceof Player) {
                Player playerTarget = (Player)target;
                for (ItemStack item : playerTarget.m_6167_()) {
                    if (playerTarget.m_36335_().m_41519_(item.m_41720_())) continue;
                    playerTarget.m_36335_().m_41524_(item.m_41720_(), this.onHitCooldown);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingTicks) {
        if (!world.m_5776_() && user instanceof Player) {
            Player player = (Player)user;
            ServerLevel serverWorld = (ServerLevel)world;
            if (remainingTicks % 4 == 0) {
                world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (remainingTicks == 1) {
                this.createLightningStrike(player, serverWorld);
                this.damageAndElectrifyEnemies(user, player, serverWorld);
                player.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown);
            }
        }
        super.m_5929_(world, user, stack, remainingTicks);
    }

    private void createLightningStrike(Player player, ServerLevel world) {
        for (int i = 0; i < 30; ++i) {
            int randomX = player.m_217043_().m_188503_(9) - 5;
            int randomZ = player.m_217043_().m_188503_(9) - 5;
            BlockPos position = player.m_20183_().m_7918_(randomX, 0, randomZ);
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
            if (lightning == null) continue;
            lightning.m_6027_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
            lightning.m_20874_(true);
            world.m_7967_((Entity)lightning);
        }
    }

    private void damageAndElectrifyEnemies(LivingEntity user, Player player, ServerLevel world) {
        int boxRange = effect.getStasisLightningRange();
        AABB box = new AABB(user.m_20185_() - (double)boxRange, user.m_20186_() - 2.0, user.m_20189_() - (double)boxRange, user.m_20185_() + (double)boxRange, user.m_20186_() + (double)(boxRange * 2), user.m_20189_() + (double)boxRange);
        for (LivingEntity entity : world.m_45976_(LivingEntity.class, box)) {
            if (entity == user || entity.m_7307_((Entity)user)) continue;
            entity.m_6469_(player.m_269291_().m_269425_(), effect.getStasisLightningDamage());
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
            if (lightning == null) continue;
            lightning.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            lightning.m_20874_(true);
            world.m_7967_((Entity)lightning);
            entity.m_8038_(world, lightning);
        }
    }

    public int m_8105_(ItemStack stack) {
        return effect.getStasisLightningWindup();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_175827_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.stasis.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.stasis.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.stasis.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.stasis.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.stasis.tooltip5").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

