/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SoulForeseerItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = 100;
    int stepMod = 0;

    public SoulForeseerItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverworld = (ServerLevel)level;
            if (attacker.m_217043_().m_216332_(1, 100) <= effect.getForeseerForeseenChance() && !target.m_21023_((MobEffect)ModEffectsRegistry.FORESEEN.get())) {
                serverworld.m_247517_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_27.get(), SoundSource.PLAYERS);
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.FORESEEN.get(), effect.getForeseerForseenTime(), 0));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10, 0));
                serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123745_, attacker.m_20185_(), attacker.m_20186_() + 1.0, attacker.m_20189_(), 50, 0.25, 0.25, 0.25, 0.1);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!player.m_9236_().m_5776_()) {
            boolean hasAffectedEntity = false;
            int boxRange = effect.getForeseerJudgeTeleportRange();
            AABB box = new AABB(player.m_20185_() - (double)boxRange, player.m_20186_() - (double)boxRange, player.m_20189_() - (double)boxRange, player.m_20185_() + (double)boxRange, player.m_20186_() + (double)boxRange, player.m_20189_() + 20.0);
            List entities = player.m_9236_().m_45976_(LivingEntity.class, box);
            for (LivingEntity livingEntity : entities) {
                if (livingEntity == player || livingEntity.m_7307_((Entity)player) || !livingEntity.m_21023_((MobEffect)ModEffectsRegistry.FORESEEN.get())) continue;
                livingEntity.m_21195_((MobEffect)ModEffectsRegistry.FORESEEN.get());
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effect.getForeseerJudgeTeleportNegativeEffectTime(), 3));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effect.getForeseerJudgeTeleportNegativeEffectTime(), 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, effect.getForeseerJudgeTeleportNegativeEffectTime(), 1));
                livingEntity.m_20324_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                livingEntity.f_19864_ = true;
                hasAffectedEntity = true;
            }
            if (hasAffectedEntity) {
                player.m_9236_().m_247517_(null, player.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_22.get(), SoundSource.PLAYERS);
                player.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123746_, ParticleTypes.f_235898_, ParticleTypes.f_123785_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.soul_foreseer.tooltip5", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(effect.getForeseerForseenTime())}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.soul_foreseer.tooltip7").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

