/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class RevvengineItem
extends SimplyMoreUniqueSwordItem {
    int stepMod = 0;

    public RevvengineItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker.m_217043_().m_216332_(1, 100) <= effect.getRevvengineBleedChance()) {
            target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effect.getRevvengineBleedTime(), 0), (Entity)attacker);
        }
        float extraDamage = RevvengineItem.getHealthModifiedValue(attacker, effect.getRevvengineMaxDamagePercentageBuff(), RevvengineItem.config.weaponAttributes.getRevvengineDamage());
        if (attacker instanceof Player) {
            Player playerAttacker = (Player)attacker;
            target.f_19802_ = 0;
            target.m_6469_(target.m_269291_().m_269075_(playerAttacker), extraDamage);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public static float getHealthModifiedValue(LivingEntity entity, int percentage, float value) {
        float hpPercentage = entity.m_21223_() / entity.m_21233_();
        float extraPercentage = (float)percentage * (1.0f - hpPercentage);
        return value * (extraPercentage / 100.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1 ? InteractionResultHolder.m_19100_((Object)itemStack) : InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        int ticksUsed;
        if (user.m_9236_().m_5776_()) {
            super.m_5929_(world, user, stack, remainingUseTicks);
            return;
        }
        if (user.f_19797_ % 5 == 0) {
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)SoundRegistry.MAGIC_BOW_PULL_BACK_SHORT_VERSION_02.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        if ((ticksUsed = this.m_7968_().m_41779_() - remainingUseTicks) >= effect.getRevvenginePhase3MinimumCharge()) {
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), user.m_20185_(), user.m_20188_(), user.m_20189_(), 22, 0.75, 0.75, 0.75, (double)0.3f);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, user.m_20185_(), user.m_20186_(), user.m_20189_(), 3, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.3f);
        } else if (ticksUsed >= effect.getRevvenginePhase2MinimumCharge()) {
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.5f, 0.5f), 1.0f), user.m_20185_(), user.m_20188_(), user.m_20189_(), 15, 0.75, 0.75, 0.75, (double)0.3f);
        } else if (ticksUsed >= effect.getRevvenginePhase1MinimumCharge()) {
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), user.m_20185_(), user.m_20188_(), user.m_20189_(), 8, 0.75, 0.75, 0.75, (double)0.3f);
        }
        super.m_5929_(world, user, stack, remainingUseTicks);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user.m_9236_().m_5776_()) {
            super.m_5551_(stack, world, user, remainingUseTicks);
            return;
        }
        int ticksUsed = this.m_7968_().m_41779_() - remainingUseTicks;
        int time = 0;
        int amplifier = 0;
        if (ticksUsed >= effect.getRevvenginePhase3MinimumCharge()) {
            amplifier = 1;
            time = (int)RevvengineItem.getHealthModifiedValue(user, effect.getRevvengineMaxRangePercentageBuff(), 45.0f);
            time += 40;
            ((Player)user).m_36335_().m_41524_((Item)this, effect.getRevvenginePhase3Cooldown());
        } else if (ticksUsed >= effect.getRevvenginePhase2MinimumCharge()) {
            time = (int)RevvengineItem.getHealthModifiedValue(user, effect.getRevvengineMaxRangePercentageBuff(), 25.0f);
            time += 25;
            ((Player)user).m_36335_().m_41524_((Item)this, effect.getRevvenginePhase2Cooldown());
        } else if (ticksUsed >= effect.getRevvenginePhase1MinimumCharge()) {
            this.phase1(user);
        }
        if (time > 0) {
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.RAVENOUS.get(), time, amplifier));
        }
        super.m_5551_(stack, world, user, remainingUseTicks);
    }

    public void phase1(LivingEntity user) {
        Vec3 position = user.m_146892_();
        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(user.m_146908_());
        Vec3 particlePos = new Vec3(position.m_7096_() + normalisedVector.x(), position.m_7098_(), position.m_7094_() + normalisedVector.z());
        AABB box = new AABB(particlePos.m_7096_() - 1.0, particlePos.m_7098_() - 1.0, particlePos.m_7094_() - 1.0, particlePos.m_7096_() + 1.0, particlePos.m_7098_() + 1.0, particlePos.m_7094_() + 1.0);
        for (LivingEntity livingEntity : user.m_9236_().m_45976_(LivingEntity.class, box)) {
            if (livingEntity.m_7307_((Entity)user) || livingEntity == user || livingEntity.m_20147_()) continue;
            livingEntity.m_6469_(user.m_269291_().m_269075_((Player)user), RevvengineItem.getHealthModifiedValue(user, effect.getRevvengineMaxDamagePercentageBuff(), effect.getRevvenginePhase1Damage()) + (float)effect.getRevvenginePhase1Damage());
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effect.getRevvengineBleedTime(), 0));
        }
        ((Player)user).m_36335_().m_41524_((Item)this, effect.getRevvenginePhase1Cooldown());
        user.m_9236_().m_6263_(null, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.5f);
        ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public int m_8105_(ItemStack stack) {
        return 9999999;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.revvengine.tooltip6").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

