/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3d;

public class MyrmedgeItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getMyrmedgeCooldown() + effect.getMyrmedgeMaxGrabTime();
    int stepMod = 0;

    public MyrmedgeItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public static float getHungerModifiedValue(Player entity, int percentage, float value) {
        float hungerPercentage = (float)entity.m_36324_().m_38702_() / 20.0f;
        float extraPercentage = (float)percentage * (1.0f - hungerPercentage);
        return value * (extraPercentage / 100.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_9236_().f_46443_) {
            return super.m_7203_(world, user, hand);
        }
        ItemStack stack = user.m_21120_(hand);
        Entity entity = HelperMethods.getTargetedEntity((Entity)user, (int)2);
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target == user || target.m_7307_((Entity)user) || target.m_21224_()) {
                return super.m_7203_(world, user, hand);
            }
            stack.m_41784_().m_128362_("simplymore:grabbed", target.m_20148_());
            user.m_36335_().m_41524_((Item)this, this.skillCooldown);
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.GRASPING.get(), effect.getMyrmedgeMaxGrabTime()));
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11865_, SoundSource.PLAYERS, 1.0f, 1.5f);
        }
        return super.m_7203_(world, user, hand);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker instanceof Player) {
            Player playerAttacker = (Player)attacker;
            float extraDamage = MyrmedgeItem.getHungerModifiedValue(playerAttacker, effect.getMyrmedgeMaxDamagePercentageBuff(), MyrmedgeItem.config.weaponAttributes.getMyrmedgeDamage());
            target.f_19802_ = 0;
            target.m_6469_(target.m_269291_().m_269075_(playerAttacker), extraDamage);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player playerEntity;
        int amplifier;
        if (world.m_46467_() % 20L == 0L && entity instanceof Player && (amplifier = (int)Math.floor(MyrmedgeItem.getHungerModifiedValue(playerEntity = (Player)entity, 500, 1.0f)) - 1) >= 0) {
            playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 25, amplifier));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if ((selected || player.m_21206_() == stack && player.m_21205_().m_41720_() != stack.m_41720_()) && player.m_21023_((MobEffect)ModEffectsRegistry.GRASPING.get()) && !player.m_9236_().f_46443_ && player.m_6084_() && stack.m_41784_().m_128441_("simplymore:grabbed")) {
                LivingEntity livingTarget;
                UUID uuid = stack.m_41784_().m_128342_("simplymore:grabbed");
                Entity target = ((ServerLevel)world).m_8791_(uuid);
                if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_6084_()) {
                    livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 10, 1));
                    livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 10, 1));
                    Vec3 blockPos = entity.m_19907_(1.2, 0.0f, false).m_82450_();
                    livingTarget.m_20324_(blockPos.m_7096_(), blockPos.m_7098_(), blockPos.m_7094_());
                    livingTarget.m_245125_();
                    livingTarget.f_19789_ = 0.0f;
                    if (world.m_46467_() % 20L == 0L) {
                        if (livingTarget instanceof Player) {
                            Player playerTarget = (Player)livingTarget;
                            playerTarget.m_36324_().m_38717_(0.0f);
                            playerTarget.m_36324_().m_38705_(playerTarget.m_36324_().m_38702_() - 1);
                        }
                        target.m_6469_(player.m_269291_().m_269075_(player), 1.0f);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11865_, SoundSource.PLAYERS, 1.0f, 2.0f);
                        player.m_36324_().m_38707_(2, 0.1f);
                        if ((float)player.m_36324_().m_38702_() >= 20.0f) {
                            player.m_5634_(1.0f);
                        }
                    }
                    if (player.m_21124_((MobEffect)ModEffectsRegistry.GRASPING.get()).m_19557_() == 1) {
                        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(player.m_146908_()).mul((double)effect.getMyrmedgeThrowStrength());
                        livingTarget.m_20256_(new Vec3(normalisedVector.x(), (double)0.2f, normalisedVector.z()));
                        livingTarget.f_19864_ = true;
                    }
                } else {
                    player.m_21195_((MobEffect)ModEffectsRegistry.GRASPING.get());
                }
            }
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.myrmedge.tooltip7", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(effect.getMyrmedgeMaxGrabTime())}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.myrmedge.tooltip9").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

