/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.config.MimicryAttributesConfig;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.registry.ModTagRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3d;

public class MimicryItem
extends SimplyMoreUniqueSwordItem {
    protected final Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
    protected final Style abilityStyle = HelperMethods.getStyle((String)"ability");
    protected final Style textStyle = HelperMethods.getStyle((String)"text");
    protected static MimicryAttributesConfig mimicryAttributes = MimicryItem.config.mimicry;
    int skillBetweenComboCooldown = effect.getMimicryCooldownBetweenTypes();
    int skillCooldown = effect.getMimicryTypeCooldown();
    public static final int usageEffectTime = 9999999;
    int stepMod = 0;

    public MimicryItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (user.m_21023_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1 ? InteractionResultHolder.m_19100_((Object)itemStack) : InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.m_9236_().f_46443_ || !(user instanceof Player)) {
            super.m_5929_(world, user, stack, remainingUseTicks);
            return;
        }
        if (remainingUseTicks == 1 && MimicryItem.getAmplifier(stack.m_41720_()) != -1) {
            user.m_21253_();
            ((Player)user).m_36335_().m_41524_((Item)this, 1000);
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get(), 9999999, MimicryItem.getAmplifier(stack.m_41720_())));
            stack.m_41784_().m_128379_("simplymore:change", true);
        }
        super.m_5929_(world, user, stack, remainingUseTicks);
    }

    public static int getAmplifier(Item item) {
        for (RegistrySupplier<Item> registry : ModItemsRegistry.MIMICRY_AMPLIFIERS) {
            if (registry.get() != item) continue;
            return ModItemsRegistry.MIMICRY_AMPLIFIERS.indexOf(registry);
        }
        return -1;
    }

    public int m_8105_(ItemStack stack) {
        return effect.getMimicryWindup();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player playerEntity;
        if (stack.m_41784_().m_128441_("simplymore:change") && stack.m_41784_().m_128471_("simplymore:change") && entity instanceof Player && !(playerEntity = (Player)entity).m_21023_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get()) && !playerEntity.m_9236_().f_46443_) {
            playerEntity.m_36335_().m_41524_(stack.m_41720_(), this.skillCooldown);
            String currentForm = null;
            for (Map.Entry<String, RegistrySupplier<Item>> itemEntry : ModItemsRegistry.MIMICRY_ITEMS.entrySet()) {
                if (itemEntry.getValue().get() != stack.m_41720_()) continue;
                currentForm = itemEntry.getKey();
            }
            String newForm = this.getWeightedRandomForm(currentForm, playerEntity);
            Item newItem = (Item)ModItemsRegistry.MIMICRY_ITEMS.get(newForm).get();
            playerEntity.m_36335_().m_41524_(newItem, this.skillBetweenComboCooldown);
            if (newItem instanceof MimicryItem) {
                MimicryItem mimicryItemToTransformInto = (MimicryItem)newItem;
                CompoundTag nbt = stack.m_41783_();
                ItemStack newItemStack = mimicryItemToTransformInto.m_7968_();
                nbt = nbt == null ? new CompoundTag() : nbt.m_6426_();
                newItemStack.m_41751_(nbt);
                newItemStack.m_41784_().m_128379_("simplymore:change", false);
                int slotIndex = playerEntity.m_150109_().m_36030_(stack);
                if (slotIndex != -1) {
                    playerEntity.m_150109_().m_6836_(slotIndex, newItemStack);
                } else if (playerEntity.m_21206_() == stack) {
                    playerEntity.m_21008_(InteractionHand.OFF_HAND, newItemStack);
                }
            }
        }
        if (!stack.m_41784_().m_128441_("simplymore:change")) {
            stack.m_41784_().m_128379_("simplymore:change", false);
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public Component getMimicryFormName() {
        return null;
    }

    public String checkItem(Item item) {
        for (Map.Entry<String, TagKey<Item>> tagKeyEntry : ModTagRegistry.MIMICRY_TAGS.entrySet()) {
            TagKey<Item> itemTagKey = tagKeyEntry.getValue();
            if (!BuiltInRegistries.f_257033_.m_263177_((Object)item).m_203656_(itemTagKey)) continue;
            return tagKeyEntry.getKey();
        }
        return null;
    }

    public boolean isFormEnabled(MimicryItem item, Player user) {
        return !user.m_36335_().m_41519_((Item)item) && !item.isFormDisabledInConfig();
    }

    public boolean isFormDisabledInConfig() {
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        MimicryItem mimicryItemToTransformInto;
        String clickedItemType;
        Item itemToTransformInto;
        if (otherStack.m_204117_(ModTagRegistry.ALL) && !player.m_21023_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get()) && (itemToTransformInto = (Item)ModItemsRegistry.MIMICRY_ITEMS.get(clickedItemType = this.checkItem(otherStack.m_41720_())).get()) instanceof MimicryItem && this.isFormEnabled(mimicryItemToTransformInto = (MimicryItem)itemToTransformInto, player)) {
            CompoundTag nbt = stack.m_41783_();
            ItemStack newItem = mimicryItemToTransformInto.m_7968_();
            nbt = nbt == null ? new CompoundTag() : nbt.m_6426_();
            newItem.m_41751_(nbt);
            int slotIndex = player.m_150109_().m_36030_(stack);
            if (slotIndex != -1) {
                player.m_150109_().m_6836_(slotIndex, newItem);
                player.m_36356_(otherStack);
                return true;
            }
        }
        return super.m_142305_(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public String getWeightedRandomForm(String currentForm, Player player) {
        ArrayList<String> availableForms = new ArrayList<String>();
        for (int i = 0; i < 36; ++i) {
            String formString;
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (!itemStack.m_204117_(ModTagRegistry.ALL) || (formString = this.checkItem(itemStack.m_41720_())) == null || !this.isFormEnabled((MimicryItem)((Object)ModItemsRegistry.MIMICRY_ITEMS.get(formString).get()), player) || availableForms.contains(formString)) continue;
            availableForms.add(formString);
        }
        int chance = Math.min(15 + availableForms.size() * 10, 50);
        if (player.m_217043_().m_216332_(1, 100) < chance) {
            availableForms.clear();
        }
        availableForms.remove(currentForm);
        if (availableForms.isEmpty()) {
            for (Map.Entry<String, RegistrySupplier<Item>> itemEntry : ModItemsRegistry.MIMICRY_ITEMS.entrySet()) {
                String formString = itemEntry.getKey();
                Item formItem = (Item)itemEntry.getValue().get();
                if (!this.isFormEnabled((MimicryItem)formItem, player) || availableForms.contains(formString) || formString.equals(currentForm)) continue;
                availableForms.add(formString);
            }
        }
        return (String)availableForms.get(new Random().nextInt(availableForms.size()));
    }

    public void usageTimeline(Player player, int ticksUsed) {
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip1").m_6270_(this.abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip2").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip3").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip4").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip5").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip6").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.tooltip7").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.mimicry.tooltip8", (Object[])new Object[]{this.getMimicryFormName()}).m_6270_(this.rightClickStyle));
        this.appendSpecificTooltip(itemStack, world, tooltip, tooltipContext);
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }

    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
    }

    public void knockback(Player player, LivingEntity target, float strength) {
        double deltaZ;
        Vec3 userPosition = player.m_20182_();
        Vec3 entityPosition = target.m_20182_();
        double deltaX = entityPosition.m_7096_() - userPosition.m_7096_();
        double distance = Math.hypot(deltaX, deltaZ = entityPosition.m_7094_() - userPosition.m_7094_());
        if (distance == 0.0) {
            return;
        }
        double normalizedDeltaX = deltaX / distance;
        double normalizedDeltaZ = deltaZ / distance;
        target.m_20334_(normalizedDeltaX * (double)strength, 0.4, normalizedDeltaZ * (double)strength);
        target.f_19864_ = true;
    }

    public void jump(LivingEntity target, float xzStrength, float yStrength) {
        Vector3d facingVector = SimplyMoreHelperMethods.getNormalised2dVector(target.m_146908_()).mul((double)xzStrength);
        target.m_20334_(facingVector.x(), (double)yStrength, facingVector.z());
        target.f_19864_ = true;
    }

    public List<LivingEntity> sweepAttack(Player player, float range) {
        return this.sweepAttack(player, range, 0);
    }

    public List<LivingEntity> sweepAttack(Player player, float range, int angle) {
        Vec3 position = player.m_146892_();
        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(player.m_146908_() + (float)angle);
        Vec3 particlePos = new Vec3(position.m_7096_() + normalisedVector.x() * (double)range, position.m_7098_(), position.m_7094_() + normalisedVector.z() * (double)range);
        AABB box = new AABB(particlePos.m_7096_() - (double)range, particlePos.m_7098_() - (double)range, particlePos.m_7094_() - (double)range, particlePos.m_7096_() + (double)range, particlePos.m_7098_() + (double)range, particlePos.m_7094_() + (double)range);
        player.m_9236_().m_6263_(null, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.5f);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        return player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != player && !livingEntity.m_7307_((Entity)player)).toList();
    }

    public List<LivingEntity> katanaAttack(Player player, double x, double y, double z, float range) {
        AABB box = new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, y, z, (int)Math.pow(range, 2.0) * 10, (double)range, 2.0, (double)range, 1.0);
        player.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.5f);
        return player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != player && !livingEntity.m_7307_((Entity)player)).toList();
    }

    public List<LivingEntity> spinAttack(Player player, float range) {
        AABB box = new AABB(player.m_20185_() - (double)range, player.m_20186_() - 1.5, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + 1.5, player.m_20189_() + (double)range);
        for (int i = 0; i < 10; ++i) {
            float particleRange = range / 1.5f;
            Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(i * 36);
            double xPos = player.m_20185_() + normalisedVector.x() * (double)particleRange;
            double yPos = player.m_20188_();
            double zPos = player.m_20189_() + normalisedVector.z() * (double)particleRange;
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, xPos, yPos, zPos, 1, 0.0, 0.0, 0.0, 0.0);
            player.m_9236_().m_6263_(null, xPos, yPos, zPos, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, (float)player.m_217043_().m_216332_(9, 14) / 10.0f);
        }
        return player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != player && !livingEntity.m_7307_((Entity)player)).toList();
    }

    public List<LivingEntity> slamAttack(Player player, float range) {
        AABB box = new AABB(player.m_20185_() - (double)range, player.m_20186_() - 1.5, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + 1.5, player.m_20189_() + (double)range);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), (int)Math.pow(range, 2.0) * 10, (double)range, 2.0, (double)range, 1.0);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.5f, 1.0f);
        return player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != player && !livingEntity.m_7307_((Entity)player)).toList();
    }

    public List<LivingEntity> stabAttack(Player player, int range, float coverage) {
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        int j = 0;
        while ((float)j < (float)range / coverage) {
            Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised3dVector((Entity)player);
            double dX = normalisedVector.x() * (double)j * (double)coverage * (double)1.2f;
            double dY = normalisedVector.y() * (double)j * (double)coverage * (double)1.2f;
            double dZ = normalisedVector.z() * (double)j * (double)coverage * (double)1.2f;
            double x = player.m_20185_() + dX;
            double y = player.m_20188_() + dY;
            double z = player.m_20189_() + dZ;
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 20, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.2f);
            player.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_12316_, SoundSource.PLAYERS, 0.5f, 1.0f);
            AABB box = new AABB(x - (double)coverage, y - (double)coverage, z - (double)coverage, x + (double)coverage, y + (double)coverage, z + (double)coverage);
            List<LivingEntity> entities = player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != player && !livingEntity.m_7307_((Entity)player) && !targets.contains(livingEntity)).toList();
            targets.addAll(entities);
            ++j;
        }
        return targets;
    }

    public static void breakShield(LivingEntity target) {
        if (target.m_21254_() && target instanceof Player) {
            Player playerEntity = (Player)target;
            playerEntity.m_36384_(true);
        }
    }
}

