/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.entity.RiftAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3f;

public class MatterbaneItem
extends SimplyMoreUniqueSwordItem {
    private static final String[] colours = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    Vector3f[] particleColours = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.667f, 0.0f), new Vector3f(1.0f, 0.333f, 1.0f), new Vector3f(0.333f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.333f), new Vector3f(0.333f, 1.0f, 0.333f), new Vector3f(1.0f, 0.75f, 0.8f), new Vector3f(1.0f, 0.333f, 0.333f), new Vector3f(0.667f, 0.667f, 0.667f), new Vector3f(0.0f, 0.667f, 0.667f), new Vector3f(0.667f, 0.0f, 0.667f), new Vector3f(0.333f, 0.333f, 1.0f), new Vector3f(0.667f, 0.333f, 0.0f), new Vector3f(0.0f, 0.667f, 0.0f), new Vector3f(0.667f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
    int skillCooldown = effect.getMatterbaneRiftCooldown();
    int stepMod = 0;

    public MatterbaneItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            Object color = user.m_21120_(hand).m_41784_().m_128423_("simplymore:color");
            color = SimplyMoreHelperMethods.getMatterbaneColor(color);
            RiftAreaEffectCloudEntity riftAreaEffectCloudEntity = new RiftAreaEffectCloudEntity(user.m_9236_(), user.m_20185_(), user.m_20186_() + 3.0, user.m_20189_(), (LivingEntity)user, (Integer)color);
            user.m_9236_().m_7967_((Entity)riftAreaEffectCloudEntity);
            user.m_9236_().m_5594_(null, user.m_20183_(), SoundEvents.f_215780_, user.m_5720_(), 1.0f, 2.0f);
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
        return super.m_7203_(world, user, hand);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_216332_(1, 100) <= effect.getMatterbaneBeamChance() && attacker instanceof Player) {
            Player player = (Player)attacker;
            this.fireBolt(player, stack);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void fireBolt(Player user, ItemStack stack) {
        user.m_9236_().m_5594_(null, user.m_20183_(), SoundEvents.f_12616_, user.m_5720_(), 1.0f, 2.0f);
        for (int j = 0; j < effect.getMatterbaneBeamRange() * 4; ++j) {
            float yaw = (float)Math.toRadians(user.m_146908_() + 90.0f);
            float velocityX = (float)Math.cos(yaw) * 0.5f;
            float velocityZ = (float)Math.sin(yaw) * 0.5f;
            double dX = velocityX * (float)j;
            double dZ = velocityZ * (float)j;
            double x = user.m_20185_();
            double y = (user.m_20188_() + user.m_20186_()) / 2.0;
            double z = user.m_20189_();
            Object color = stack.m_41784_().m_128423_("simplymore:color");
            color = SimplyMoreHelperMethods.getMatterbaneColor(color);
            DustParticleOptions particleEffect = new DustParticleOptions(this.particleColours[(Integer)color], 2.0f);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)particleEffect, x + dX, y, z + dZ, 1, 0.0, 0.0, 0.0, 0.0);
            for (LivingEntity entity : user.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 0.6 + dX, y - 0.6, z - 0.6 + dZ, x + 0.6 + dX, y + 0.6, z + 0.6 + dZ))) {
                if (entity.m_7307_((Entity)user) || entity == user || entity.m_20147_()) continue;
                entity.m_6469_(user.m_269291_().m_269425_(), (float)effect.getMatterbaneBeamDamage());
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        Object color = itemStack.m_41784_().m_128423_("simplymore:color");
        color = (Integer)(color = Integer.valueOf(SimplyMoreHelperMethods.getMatterbaneColor(color))) >= 0 && (Integer)color <= 15 ? colours[(Integer)color] : colours[14];
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.matterbane.tooltip3", (Object[])new Object[]{effect.getMatterbaneBeamRange()}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip9").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip10").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.matterbane.tooltip11").m_7220_((Component)Component.m_237115_((String)("item.simplymore.matterbane.color_" + String.valueOf(color)))).m_6270_(abilityStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

