/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class LustrousMoxieItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getLustrousRadiantTeleportCooldown();
    int stepMod = 0;

    public LustrousMoxieItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            MobEffectInstance radiantMarkEffect = target.m_21124_((MobEffect)ModEffectsRegistry.RADIANT_MARK.get());
            if (target.m_21023_((MobEffect)ModEffectsRegistry.RADIANT_MARK.get()) && radiantMarkEffect != null) {
                target.m_6469_(attacker.m_269291_().m_269425_(), (float)(radiantMarkEffect.m_19564_() + 1));
            }
            if (attacker.m_217043_().m_216332_(1, 100) <= effect.getLustrousRadiantMarkChance()) {
                if (target.m_21023_((MobEffect)ModEffectsRegistry.RADIANT_MARK.get()) && radiantMarkEffect != null) {
                    int amplifier = radiantMarkEffect.m_19564_() + 1;
                    int duration = 240 - amplifier * 40;
                    target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.RADIANT_MARK.get(), duration, amplifier), (Entity)attacker);
                } else {
                    target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.RADIANT_MARK.get(), 200, 0), (Entity)attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void attack(Player user) {
        if (user.m_9236_().m_5776_()) {
            return;
        }
        LivingEntity target = this.locateRadiantMarkedTarget(user);
        if (target != null) {
            this.damageAndKnockbackAndTeleportToRadiantMarkedTarget(target, user);
            this.damageAndKnockbackNearbyNonRadiantMarkedEntities(target, user);
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STUNNED_MOXIE.get(), effect.getLustrousRadiantTeleportStunTime(), 0));
            user.m_9236_().m_247517_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_01.get(), SoundSource.PLAYERS);
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
    }

    private LivingEntity locateRadiantMarkedTarget(Player user) {
        int boxRange = effect.getLustrousRadiantTeleportRange();
        AABB box = new AABB(user.m_20185_() - (double)boxRange, user.m_20186_() - (double)boxRange, user.m_20189_() - (double)boxRange, user.m_20185_() + (double)boxRange, user.m_20186_() + (double)boxRange, user.m_20189_() + (double)boxRange);
        List potentiallyMarkedLivingEntities = user.m_9236_().m_45976_(LivingEntity.class, box);
        LivingEntity markedEntity = potentiallyMarkedLivingEntities.stream().filter(livingEntity -> livingEntity.m_21023_((MobEffect)ModEffectsRegistry.RADIANT_MARK.get())).findAny().orElse(null);
        if (markedEntity == null || markedEntity == user || markedEntity.m_7307_((Entity)user)) {
            return null;
        }
        return markedEntity;
    }

    private void damageAndKnockbackAndTeleportToRadiantMarkedTarget(LivingEntity targetEntity, Player user) {
        if (targetEntity == user.m_21214_()) {
            user.m_20984_(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_(), false);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175829_, user.m_20185_(), user.m_20186_() + 2.0, user.m_20189_(), 500, 3.0, 3.0, 3.0, 0.0);
            targetEntity.m_21195_((MobEffect)ModEffectsRegistry.RADIANT_MARK.get());
            this.knockbackAndDamageEntity(targetEntity, user, effect.getLustrousRadiantTeleportTargetDamage());
        }
    }

    private void damageAndKnockbackNearbyNonRadiantMarkedEntities(LivingEntity targetEntity, Player user) {
        int boxRange = effect.getLustrousRadiantTeleportAOERange();
        AABB box = new AABB(user.m_20185_() - (double)boxRange, user.m_20186_() - (double)boxRange, user.m_20189_() - (double)boxRange, user.m_20185_() + (double)boxRange, user.m_20186_() + (double)boxRange, user.m_20189_() + (double)boxRange);
        List nearbyLivingEntities = user.m_9236_().m_45976_(LivingEntity.class, box);
        nearbyLivingEntities.remove(targetEntity);
        for (LivingEntity livingEntity : nearbyLivingEntities) {
            this.knockbackAndDamageEntity(livingEntity, user, effect.getLustrousRadiantTeleportAOEDamage());
        }
    }

    private void knockbackAndDamageEntity(LivingEntity targetEntity, Player user, float damage) {
        if (targetEntity == user || targetEntity.m_7307_((Entity)user)) {
            return;
        }
        targetEntity.m_6469_(user.m_269291_().m_269075_(user), damage);
        Vec3 userPosition = user.m_20182_();
        Vec3 entityPosition = targetEntity.m_20182_();
        double deltaX = entityPosition.m_7096_() - userPosition.m_7096_();
        double deltaZ = entityPosition.m_7094_() - userPosition.m_7094_();
        double distance = Math.hypot(deltaX, deltaZ);
        if (distance == 0.0) {
            return;
        }
        double normalizedDeltaX = deltaX / distance;
        double normalizedDeltaZ = deltaZ / distance;
        targetEntity.m_20334_(normalizedDeltaX * (double)effect.getLustrousRadiantTeleportAOEKnockback(), 0.2, normalizedDeltaZ * (double)effect.getLustrousRadiantTeleportAOEKnockback());
        targetEntity.f_19864_ = true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1 ? InteractionResultHolder.m_19100_((Object)itemStack) : InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!user.m_9236_().f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            if (remainingUseTicks == 1) {
                this.attack(player);
            }
        }
        super.m_5929_(world, user, stack, remainingUseTicks);
    }

    public int m_8105_(ItemStack stack) {
        return 15;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_175829_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip9").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.lustrous_moxie.tooltip10").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

