/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class GrandfrostItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getGrandfrostBlizzardCooldown();
    int stepMod = 0;

    public GrandfrostItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && (attacker.m_217043_().m_216332_(1, 100) <= effect.getGrandfrostChillingChance() || target.m_21254_())) {
            target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.CHILL.get(), effect.getGrandfrostChillingTime(), 0), (Entity)attacker);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_9236_().m_5776_()) {
            return super.m_7203_(world, user, hand);
        }
        int boxSize = effect.getGrandfrostBlizzardRange();
        AABB box = new AABB(user.m_20185_() - (double)boxSize, user.m_20186_() - 2.0, user.m_20189_() - (double)boxSize, user.m_20185_() + (double)boxSize, user.m_20186_() + (double)boxSize, user.m_20189_() + (double)boxSize);
        List livingEntities = user.m_9236_().m_45976_(LivingEntity.class, box);
        if (livingEntities.size() > 1) {
            boolean isNonTeammateNearby = false;
            for (LivingEntity livingEntity : livingEntities) {
                double deltaZ;
                if (livingEntity == user || livingEntity.m_7307_((Entity)user)) continue;
                isNonTeammateNearby = true;
                Vec3 userPosition = user.m_20182_();
                Vec3 entityPosition = livingEntity.m_20182_();
                double deltaX = entityPosition.m_7096_() - userPosition.m_7096_();
                double distance = Math.hypot(deltaX, deltaZ = entityPosition.m_7094_() - userPosition.m_7094_());
                if (distance == 0.0) {
                    return super.m_7203_(world, user, hand);
                }
                float knockbackStrength = effect.getGrandfrostBlizzardStrength();
                double normalizedDeltaX = deltaX / distance;
                double normalizedDeltaZ = deltaZ / distance;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.CHILL.get(), effect.getGrandfrostBlizzardEffectTime(), 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effect.getGrandfrostBlizzardEffectTime(), 3));
                livingEntity.m_20334_(normalizedDeltaX * (double)knockbackStrength, 0.4, normalizedDeltaZ * (double)knockbackStrength);
                livingEntity.f_19864_ = true;
            }
            if (isNonTeammateNearby) {
                user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
                ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175821_, user.m_20185_(), user.m_20186_() + 3.0, user.m_20189_(), 1000, 3.0, 0.0, 3.0, 0.25);
                user.m_9236_().m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_03.get(), user.m_5720_(), 2.0f, 0.3f);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123754_, ParticleTypes.f_123754_, ParticleTypes.f_175821_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.grandfrost.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.grandfrost.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.grandfrost.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.grandfrost.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.grandfrost.tooltip5").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

