/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3f;

public class GlimmerstepItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getGlimmerstepExplosionCooldown();
    int stepMod = 0;

    public GlimmerstepItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int chance;
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        int n = chance = attacker.m_20202_() instanceof LivingEntity ? effect.getGlimmerstepStarlightMountedChance() : effect.getGlimmerstepStarlightChance();
        if (attacker.m_217043_().m_216332_(1, 100) <= chance) {
            if (attacker.m_21023_((MobEffect)ModEffectsRegistry.STARLIGHT.get())) {
                int amplifier = attacker.m_21124_((MobEffect)ModEffectsRegistry.STARLIGHT.get()).m_19564_();
                amplifier = Math.min(amplifier + 1, effect.getGlimmerstepMaxStarlight() - 1);
                attacker.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STARLIGHT.get(), effect.getGlimmerstepStarlightTime(), amplifier), (Entity)attacker);
            } else {
                attacker.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STARLIGHT.get(), effect.getGlimmerstepStarlightTime(), 0), (Entity)attacker);
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effect.getGlimmerstepBlindTime()));
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12376_, SoundSource.PLAYERS, 1.0f, 2.0f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (!user.m_21023_((MobEffect)ModEffectsRegistry.STARLIGHT.get())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1 ? InteractionResultHolder.m_19100_((Object)itemStack) : InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.m_9236_().f_46443_ || !(user instanceof Player)) {
            super.m_5929_(world, user, stack, remainingUseTicks);
            return;
        }
        int ticksUsed = this.m_8105_(this.m_7968_()) - remainingUseTicks;
        if (ticksUsed == 1) {
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.2f);
        }
        ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(2.0f, 2.0f, 1.0f), 2.0f), user.m_20185_(), user.m_20188_(), user.m_20189_(), Math.min(ticksUsed, Math.min(60, effect.getGlimmerstepExplosionCharge())), 4.0, 4.0, 4.0, 0.0);
        if (ticksUsed == effect.getGlimmerstepExplosionCharge()) {
            user.m_21253_();
            int boxSize = effect.getGlimmerstepExplosionRange();
            AABB box = new AABB(user.m_20185_() - (double)boxSize, user.m_20186_() - 2.0, user.m_20189_() - (double)boxSize, user.m_20185_() + (double)boxSize, user.m_20186_() + (double)boxSize, user.m_20189_() + (double)boxSize);
            List livingEntities = user.m_9236_().m_45976_(LivingEntity.class, box);
            float damage = 0.0f;
            try {
                damage = effect.getGlimmerstepExplosionDamagePerStarlight() * (float)(user.m_21124_((MobEffect)ModEffectsRegistry.STARLIGHT.get()).m_19564_() + 1);
            }
            catch (NullPointerException e) {
                damage = effect.getGlimmerstepExplosionDamagePerStarlight();
            }
            ((Player)user).m_36335_().m_41524_((Item)this, this.skillCooldown);
            user.m_21195_((MobEffect)ModEffectsRegistry.STARLIGHT.get());
            float finalDamage = damage;
            livingEntities.stream().filter(livingEntity -> {
                TamableAnimal tame;
                return !(livingEntity instanceof TamableAnimal && (tame = (TamableAnimal)livingEntity).m_21830_(user));
            }).forEach(livingEntity -> livingEntity.m_6469_(user.m_269291_().m_269036_((Entity)user, (Entity)user), livingEntity.m_7307_((Entity)user) || livingEntity == user ? finalDamage * ((float)effect.getGlimmerstepSelfAndAllyDamagePercentage() / 100.0f) : finalDamage));
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, user.m_20185_(), user.m_20188_(), user.m_20189_(), 80, 2.0, 2.0, 2.0, 0.0);
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        super.m_5929_(world, user, stack, remainingUseTicks);
    }

    public int m_8105_(ItemStack stack) {
        return 9999999;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity.m_20202_() instanceof LivingEntity && selected && ((Player)entity).m_21120_(InteractionHand.OFF_HAND).m_41720_().m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).isEmpty()) {
            ((Player)entity).m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.LANCE.get(), 9999999, 0));
        }
        super.m_6883_(stack, world, entity, slot, selected);
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_175830_, ParticleTypes.f_175830_, ParticleTypes.f_123815_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.glimmerstep.tooltip2", (Object[])new Object[]{effect.getGlimmerstepMaxStarlight()}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.glimmerstep.tooltip9").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

