/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.entity.GhostFallingBlockEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.CooldownOnUnselected;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3d;

public class ExedrillItem
extends SimplyMoreUniqueSwordItem
implements CooldownOnUnselected {
    int skillCooldown = effect.getExedrillCooldown();
    static int maxHeat = effect.getExedrillMaxHeat();
    static final int minHeat = 0;
    int stepMod = 0;

    public ExedrillItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int chance;
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        if (ExedrillItem.getHeat(stack) >= maxHeat && attacker instanceof Player) {
            Player player = (Player)attacker;
            ExedrillItem.setHeat(stack, 0);
            List<LivingEntity> targets = ExedrillItem.tremorEffectHitbox(8, attacker.m_20182_(), (ServerLevel)attacker.m_9236_(), player);
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.5f, 0.5f);
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.5f, 1.0f);
            ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, attacker.m_20185_(), attacker.m_20188_(), attacker.m_20189_(), 4, 0.25, 0.25, 0.25, 0.0);
            targets.forEach(livingEntity -> {
                livingEntity.m_6469_(player.m_269291_().m_269036_((Entity)player, (Entity)player), effect.getExedrillExplosionDamage());
                double deltaX = livingEntity.m_20185_() - player.m_20185_();
                double deltaZ = livingEntity.m_20189_() - player.m_20189_();
                double distance = Math.hypot(deltaX, deltaZ);
                float knockbackStrength = effect.getExedrillEarthquakePushStrength();
                double normalizedDeltaX = deltaX / distance;
                double normalizedDeltaZ = deltaZ / distance;
                if (distance == 0.0) {
                    return;
                }
                livingEntity.m_5997_(normalizedDeltaX * (double)knockbackStrength, (double)0.4f, normalizedDeltaZ * (double)knockbackStrength);
            });
            return super.m_7579_(stack, target, attacker);
        }
        ExedrillItem.setHeat(stack, ExedrillItem.getHeat(stack) + effect.getExedrillHitHeatAmount());
        int n = chance = attacker.m_20202_() instanceof LivingEntity ? effect.getExedrillTrembleMountedChance() : effect.getExedrillTrembleChance();
        if (attacker.m_217043_().m_216332_(1, 100) <= chance && attacker instanceof Player) {
            Player player = (Player)attacker;
            List<LivingEntity> targets = ExedrillItem.tremorEffectHitbox(5, attacker.m_20182_(), (ServerLevel)attacker.m_9236_(), player);
            ExedrillItem.setHeat(stack, ExedrillItem.getHeat(stack) + effect.getExedrillTrembleHeatAmount());
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.5f, 0.5f);
            int effectTime = effect.getExedrillTrembleEffectTime();
            targets.forEach(entity -> {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime, 1));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime));
                entity.m_5997_(0.0, 0.2, 0.0);
            });
        }
        return super.m_7579_(stack, target, attacker);
    }

    public static int getHeat(ItemStack stack) {
        int heat = stack.m_41784_().m_128451_("simplymore:heat");
        heat = Math.max(0, heat);
        heat = Math.min(maxHeat, heat);
        return heat;
    }

    public static void setHeat(ItemStack stack, int value) {
        stack.m_41784_().m_128405_("simplymore:heat", value);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_9236_().m_5776_()) {
            return super.m_7203_(world, user, hand);
        }
        for (int i = 0; i < effect.getExedrillRocksAmount(); ++i) {
            Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(user.m_146908_() + (float)user.m_217043_().m_216332_(-40, 40));
            Vec3 rockVelocity = new Vec3(normalisedVector.x() * (double)effect.getExedrillRockSpeed(), (double)0.45f, normalisedVector.z() * (double)effect.getExedrillRockSpeed());
            GhostFallingBlockEntity rock = new GhostFallingBlockEntity(world, user.m_20185_(), user.m_20186_(), user.m_20189_(), rockVelocity, (LivingEntity)user);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)Blocks.f_50069_.m_49966_()));
            rock.m_7378_(nbt);
            user.m_9236_().m_7967_((Entity)rock);
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_144050_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        user.m_36335_().m_41524_((Item)this, this.skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    public static List<LivingEntity> tremorEffectHitbox(int range, Vec3 pos, ServerLevel world, Player player) {
        world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), pos.m_7096_(), pos.m_7098_() + 0.5, pos.m_7094_(), (int)(Math.pow(range, 2.0) * 30.0), (double)range, 0.5, (double)range, 1.0);
        AABB box = new AABB(player.m_20185_() - (double)range, player.m_20186_() - 2.0, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + (double)range, player.m_20189_() + (double)range);
        return player.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> {
            TraceableEntity pet;
            return livingEntity != player && !livingEntity.m_7307_((Entity)player) && (!(livingEntity instanceof TraceableEntity) || (pet = (TraceableEntity)livingEntity).m_19749_() != player);
        }).toList();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity.m_20202_() instanceof LivingEntity && selected && ((Player)entity).m_21120_(InteractionHand.OFF_HAND).m_41720_().m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).isEmpty()) {
            ((Player)entity).m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.LANCE.get(), 9999999, 0));
        }
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.detectCooldown(player, selected, stack, this.skillCooldown, false);
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.exedrill.tooltip9").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

