/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EarthshatterItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getEarthshatterSlamCooldown();
    int stepMod = 0;

    public EarthshatterItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_216332_(1, 100) <= effect.getEarthshatterArmorCrunchChance()) {
            MobEffectInstance armourCrunchEffect = target.m_21124_((MobEffect)ModEffectsRegistry.ARMOUR_CRUNCH.get());
            if (armourCrunchEffect != null) {
                int amplifier = armourCrunchEffect.m_19564_() + 1;
                target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.ARMOUR_CRUNCH.get(), 200, amplifier), (Entity)attacker);
            } else {
                target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.ARMOUR_CRUNCH.get(), 200, 0), (Entity)attacker);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1 ? InteractionResultHolder.m_19100_((Object)itemStack) : InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!user.m_9236_().f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            if (remainingUseTicks == this.m_8105_(null) - 1) {
                user.m_9236_().m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.m_5720_(), 1.0f, 1.2f);
            }
            if (remainingUseTicks == 1) {
                this.attack(world, player);
            }
        }
        super.m_5929_(world, user, stack, remainingUseTicks);
    }

    private void attack(Level world, Player player) {
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        ServerLevel serverWorld = (ServerLevel)player.m_9236_();
        BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_());
        serverWorld.m_8767_((ParticleOptions)particleEffect, playerX, playerY + 1.0, playerZ, 500, 3.0, 1.0, 3.0, 0.0);
        SoundSource soundCategory = player.m_5720_();
        serverWorld.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_FIRE_ATTACK_01.get(), soundCategory, 1.0f, 0.0f);
        serverWorld.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_FIRE_ATTACK_02.get(), soundCategory, 1.0f, 0.0f);
        serverWorld.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_FIRE_ATTACK_03.get(), soundCategory, 1.0f, 0.0f);
        player.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        AABB box = new AABB(playerX - 4.0, playerY - 2.0, playerZ - 4.0, playerX + 4.0, playerY + 5.0, playerZ + 4.0);
        DamageSource damageSource = player.m_269291_().m_269075_(player);
        for (LivingEntity livingEntity : serverWorld.m_45976_(LivingEntity.class, box)) {
            if (livingEntity == player || livingEntity.m_7307_((Entity)player)) continue;
            livingEntity.m_6469_(damageSource, 15.0f);
            int effectTime = effect.getEarthshatterSlamEffectTime();
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.ARMOUR_CRUNCH.get(), effectTime, 2));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, effectTime, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime, 1));
            livingEntity.m_20334_(0.0, 1.2, 0.0);
            livingEntity.f_19864_ = true;
        }
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.earthshatter.tooltip8").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

