/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.entity.CrowEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModEntityRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3f;

public class DeathsEyrieItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getDeathsEyrieCooldown();
    public static final int maxCrows = 5;
    int stepMod = 0;

    public DeathsEyrieItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player playerAttacker;
        if (!attacker.m_9236_().m_5776_() && attacker instanceof Player && !(playerAttacker = (Player)attacker).m_36335_().m_41519_((Item)this) && attacker.m_217043_().m_216332_(1, 100) <= effect.getDeathsEyrieBleedChance()) {
            int effectTime = effect.getDeathsEyrieBaseBleedTime();
            int amplifier = (int)Math.floor(0.75f * (float)(DeathsEyrieItem.getCrows(stack) - 1));
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effectTime += effect.getDeathsEyrieCrowAdditionalBleedTime() * DeathsEyrieItem.getCrows(stack), amplifier));
            int crows = DeathsEyrieItem.getCrows(stack);
            if (crows < 5) {
                DeathsEyrieItem.setCrows(stack, crows + 1);
            }
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        LivingEntity target;
        if (user.m_9236_().f_46443_) {
            return super.m_7203_(world, user, hand);
        }
        Entity entityTarget = HelperMethods.getTargetedEntity((Entity)user, (int)20);
        if (entityTarget instanceof LivingEntity && !(target = (LivingEntity)entityTarget).m_7307_((Entity)user)) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19619_, 10, 0), (Entity)user);
            List pets = world.m_6443_(CrowEntity.class, user.m_20191_().m_82400_(50.0), crowEntity -> crowEntity.m_269323_() == user);
            if (!pets.isEmpty()) {
                AtomicInteger offset = new AtomicInteger();
                pets.forEach(crowEntity -> {
                    crowEntity.setAttackingTime(offset.get() + pets.size() * effect.getDeathsEyrieCrowAttackTimePerCrow());
                    offset.getAndIncrement();
                    crowEntity.setAttackingUuid(target.m_20148_());
                });
                DeathsEyrieItem.setCrows(user.m_21120_(hand), 1);
                user.m_36335_().m_41524_((Item)this, this.skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    public static int getCrows(ItemStack stack) {
        boolean minCrows = true;
        int crows = stack.m_41784_().m_128451_("simplymore:crow");
        crows = Math.max(1, crows);
        crows = Math.min(5, crows);
        return crows;
    }

    public static void setCrows(ItemStack stack, int value) {
        stack.m_41784_().m_128405_("simplymore:crow", value);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (selected && !player.m_9236_().f_46443_ && player.m_21205_().equals(stack)) {
                int crows = DeathsEyrieItem.getCrows(stack);
                List pets = world.m_6443_(CrowEntity.class, player.m_20191_().m_82400_(50.0), crowEntity -> crowEntity.m_269323_() == player);
                if (!player.m_36335_().m_41519_((Item)this)) {
                    if (pets.size() > crows) {
                        ((CrowEntity)((Object)pets.get(0))).m_6074_();
                    } else if (pets.size() < crows) {
                        double dX = (double)player.m_217043_().m_216332_(-15, 15) / 10.0;
                        double dZ = (double)player.m_217043_().m_216332_(-15, 15) / 10.0;
                        CrowEntity crowEntity2 = new CrowEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntityRegistry.CROW.get()), world);
                        crowEntity2.m_21828_(player);
                        crowEntity2.m_20343_(player.m_20185_() + dX, player.m_20188_() + 1.0, player.m_20189_() + dZ);
                        player.m_9236_().m_6263_(null, player.m_20185_() + dX, player.m_20188_() + 1.0, player.m_20189_() + dZ, SoundEvents.f_12259_, SoundSource.NEUTRAL, 1.0f, 0.6f);
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.2f), 3.0f), player.m_20185_() + dX, player.m_20188_() + 1.25, player.m_20189_() + dZ, 5, (double)0.2f, (double)0.2f, (double)0.2f, 0.0);
                        player.m_9236_().m_7967_((Entity)crowEntity2);
                    }
                }
            }
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123785_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip8").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip9").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip10").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.deaths_eyrie.tooltip11").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

