/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.CooldownOnUnselected;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class CindergorgeItem
extends SimplyMoreUniqueSwordItem
implements CooldownOnUnselected {
    int skillCooldown = effect.getCindergorgeMaxCooldown();
    int stepMod = 0;

    public CindergorgeItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        this.startUsing(itemStack, hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        int ticksUntilUseEnd = this.m_8105_(stack) - remainingUseTicks;
        if (remainingUseTicks == 1) {
            user.m_21253_();
        }
        float originalYaw = user.m_146908_();
        float turnAngle = 54.0f * (1.0f - (float)remainingUseTicks / (float)effect.getCindergorgeMaxDuration());
        user.m_146922_(originalYaw + turnAngle);
        if (user instanceof ServerPlayer) {
            double yawAngle = Math.toRadians(user.m_146908_());
            double cosYaw = Math.cos(yawAngle);
            double sinYaw = Math.sin(yawAngle);
            for (int distanceMultiplier = 1; distanceMultiplier < effect.getCindergorgeFireRange(); ++distanceMultiplier) {
                double offsetX = (double)(-distanceMultiplier) * sinYaw;
                double offsetZ = (double)distanceMultiplier * cosYaw;
                double spawnX = user.m_20185_() + 1.2 * offsetX;
                double spawnZ = user.m_20189_() + 1.2 * offsetZ;
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123744_, spawnX, user.m_20188_(), spawnZ, 20, 0.2, 0.2, 0.2, 0.1);
                world.m_6263_(null, spawnX, user.m_20188_(), spawnZ, SoundEvents.f_11874_, SoundSource.PLAYERS, 0.1f, 1.0f);
                for (LivingEntity entity : user.m_9236_().m_45976_(LivingEntity.class, new AABB(spawnX - 0.75, user.m_20188_() - 0.75, spawnZ - 0.75, spawnX + 0.75, user.m_20188_() + 0.75, spawnZ + 0.75))) {
                    if (entity.m_7307_((Entity)user) || entity == user || entity.m_20147_()) continue;
                    entity.m_6469_(user.m_269291_().m_269387_(), effect.getCindergorgeFireDamage());
                    entity.m_20254_(3);
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        float relativeTime = 1.0f - (float)remainingUseTicks / (float)effect.getCindergorgeMaxDuration();
        float cooldown = (float)this.skillCooldown * relativeTime;
        cooldown = Math.max(cooldown, 120.0f);
        user.m_7292_(new MobEffectInstance(MobEffects.f_19604_, (int)(150.0f * relativeTime)));
        super.m_5551_(stack, world, user, remainingUseTicks);
        ((Player)user).m_36335_().m_41524_(this.m_7968_().m_41720_(), (int)cooldown);
    }

    public int m_8105_(ItemStack stack) {
        return effect.getCindergorgeMaxDuration();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.detectCooldown(player, selected, stack, this.skillCooldown, false);
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123756_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.cindergorge.tooltip7").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

