/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.config.WeaponAttributesConfig;
import net.rosemarythyme.simplymore.entity.JetAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class BrassturnItem
extends SimplyMoreUniqueSwordItem {
    protected static WeaponAttributesConfig attributes = BrassturnItem.config.weaponAttributes;
    int stepMod = 0;

    public BrassturnItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, EquipmentSlot slot) {
        double attackSpeedModifier = (double)BrassturnItem.getOxidisation(stack) * (((double)3.4f + attributes.getBrassturnMaxSwingSpeed()) / -16.0);
        Multimap attributeModifiers = super.m_7167_(slot);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(attributeModifiers);
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("ebdfffcf-7f0d-4502-96ec-e4f6b995fe2f"), "Weapon modifier", attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND ? builder.build() : super.m_7167_(slot);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_9236_().m_5776_()) {
            return super.m_7579_(stack, target, attacker);
        }
        int oxidisation = BrassturnItem.getOxidisation(stack) + 1;
        BrassturnItem.saveOxidisation(stack, oxidisation);
        if (attacker.m_217043_().m_216332_(1, 100) <= effect.getBrassturnJetChance()) {
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12609_, SoundSource.PLAYERS, 0.5f, 2.0f);
            ((ServerLevel)attacker.m_9236_()).m_7967_((Entity)new JetAreaEffectCloudEntity(target.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), attacker));
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (BrassturnItem.getOxidisation(itemStack) <= 0) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        Level level;
        if (BrassturnItem.getOxidisation(stack) <= 0) {
            user.m_21253_();
        }
        if (remainingUseTicks % effect.getBrassturnScrapeTime() == 0 && (level = user.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            int oxidisation = BrassturnItem.getOxidisation(stack) - 1;
            BrassturnItem.saveOxidisation(stack, oxidisation);
            if (user.m_217043_().m_216332_(1, 100) <= effect.getBrassturnSparkChance()) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175828_, user.m_20185_(), user.m_20186_(), user.m_20189_(), 20, 0.5, 1.0, 0.5, 0.2);
                serverWorld.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 0.5f, 2.0f);
                int boxSize = 3;
                AABB box = new AABB(user.m_20185_() - (double)boxSize, user.m_20186_() - 2.0, user.m_20189_() - (double)boxSize, user.m_20185_() + (double)boxSize, user.m_20186_() + (double)boxSize, user.m_20189_() + (double)boxSize);
                List livingEntities = user.m_9236_().m_45976_(LivingEntity.class, box);
                for (LivingEntity livingEntity : livingEntities) {
                    if (livingEntity == user || livingEntity.m_7307_((Entity)user)) continue;
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STUNNED.get(), effect.getBrassturnSparkStunDuration(), 0));
                }
            } else {
                serverWorld.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_144059_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 999999;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static int getOxidisation(ItemStack stack) {
        int maxOxidisation = 16;
        Tag oxiRaw = stack.m_41784_().m_128423_("simplymore:oxidisation");
        if (oxiRaw == null) {
            BrassturnItem.saveOxidisation(stack, 16);
            return 16;
        }
        String oxiString = oxiRaw.toString().replaceAll("\"", "");
        int oxiNumber = 0;
        try {
            oxiNumber = Math.min(16, Integer.parseInt(oxiString));
        }
        catch (NumberFormatException e) {
            oxiNumber = 16;
            BrassturnItem.saveOxidisation(stack, 16);
        }
        return oxiNumber;
    }

    public static void saveOxidisation(ItemStack stack, int oxidisation) {
        stack.m_41784_().m_128359_("simplymore:oxidisation", Integer.toString(oxidisation));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.brassturn.tooltip6").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

