/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.joml.Vector3f;

public class BoasFangItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getBoasFangSpitCooldown();
    int stepMod = 0;

    public BoasFangItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_216332_(1, 100) <= effect.getBoasFangSuffocationChance()) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.SUFFOCATION.get(), effect.getBoasFangSuffocationTime()));
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                float yaw = (float)Math.toRadians(user.m_146908_() + 90.0f + (float)user.m_217043_().m_188503_(61) - 30.0f);
                float pitch = (float)Math.toRadians(user.m_146909_() + (float)user.m_217043_().m_188503_(61) - 30.0f);
                float velocityX = (float)(Math.cos(yaw) * Math.cos(pitch)) * 0.5f;
                float velocityZ = (float)(Math.sin(yaw) * Math.cos(pitch)) * 0.5f;
                float velocityY = (float)Math.sin(pitch) * -0.5f;
                user.m_9236_().m_5594_(null, user.m_20183_(), SoundEvents.f_12098_, SoundSource.PLAYERS, 1.0f, 0.0f);
                for (int j = 0; j < 14; ++j) {
                    double dX = velocityX * (float)j;
                    double dY = velocityY * (float)j;
                    double dZ = velocityZ * (float)j;
                    double x = user.m_20185_();
                    double y = user.m_20188_();
                    double z = user.m_20189_();
                    DustParticleOptions particleEffect = new DustParticleOptions(new Vector3f(0.05f, 1.0f, 0.1f), 1.0f);
                    ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)particleEffect, x + dX, y + dY, z + dZ, 1, 0.0, 0.0, 0.0, 0.0);
                    for (LivingEntity entity : user.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 0.25 + dX, y - 0.25 + dY, z - 0.25 + dZ, x + 0.25 + dX, y + 0.25 + dY, z + 0.25 + dZ))) {
                        if (entity.m_7307_((Entity)user) || entity == user || entity.m_20147_() || entity.m_21254_()) continue;
                        entity.m_6469_(user.m_269291_().m_269425_(), effect.getBoasFangSpitDamage());
                        entity.m_20334_((double)(velocityX / 2.0f), (double)(velocityY / 2.0f), (double)(velocityZ / 2.0f));
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effect.getBoasFangSpitPoisonTime(), 1));
                    }
                }
                user.m_20256_(user.m_20154_().m_82548_().m_82490_((double)effect.getBoasFangSpitSelfKnockback()));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                user.f_19864_ = true;
                user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, effect.getBoasFangSpitSpeedTime(), 1));
            }
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_175833_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip5").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.boas_fang.tooltip6").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

