/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class BladeOfTheGrotesqueItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getGrotesqueSolidifyCooldown();
    int skillLength = effect.getGrotesqueSolidifySelfStunTime();
    int stepMod = 0;

    public BladeOfTheGrotesqueItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Multimap attributeModifiers = super.m_7167_(slot);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(attributeModifiers);
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("e86446a8-b79b-46af-b171-4b47626fc4c3"), "Weapon modifier", (double)effect.getGrotesqueSelfSlow(), AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND ? builder.build() : super.m_7167_(slot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            user.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.SOLIDIFIED.get(), this.skillLength));
            user.m_9236_().m_5594_(null, user.m_20183_(), SoundEvents.f_12494_, user.m_5720_(), 2.0f, 1.0f);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123783_, user.m_20185_(), user.m_20188_() - 0.25, user.m_20189_(), 1000, 0.2, 0.5, 0.2, 1.0);
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
        return super.m_7203_(world, user, hand);
    }

    public static void causeStun(LivingEntity player) {
        int boxRange = effect.getGrotesqueAuraRange();
        AABB box = new AABB(player.m_20185_() + (double)boxRange, player.m_20186_() + (double)boxRange, player.m_20189_() + (double)boxRange, player.m_20185_() - (double)boxRange, player.m_20186_() - (double)boxRange, player.m_20189_() - (double)boxRange);
        List livingEntities = player.m_9236_().m_45976_(LivingEntity.class, box);
        for (LivingEntity livingEntity : livingEntities) {
            if (livingEntity == player || livingEntity.m_7307_((Entity)player)) continue;
            livingEntity.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STUNNED.get(), effect.getGrotesqueSolidifyAuraStunTime()), (Entity)player);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.m_46467_() % 40L == 0L && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (selected) {
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123772_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 200, 2.0, 2.0, 2.0, (double)0.1f);
                int boxRange = effect.getGrotesqueAuraRange();
                AABB box = new AABB(player.m_20185_() + (double)boxRange, player.m_20186_() + (double)boxRange, player.m_20189_() + (double)boxRange, player.m_20185_() - (double)boxRange, player.m_20186_() - (double)boxRange, player.m_20189_() - (double)boxRange);
                List livingEntities = entity.m_9236_().m_45976_(LivingEntity.class, box);
                for (LivingEntity livingEntity : livingEntities) {
                    if (livingEntity == entity || livingEntity.m_7307_(entity)) continue;
                    if (livingEntity.m_21023_((MobEffect)ModEffectsRegistry.GROTESQUE_WARD.get())) {
                        int amplifier = livingEntity.m_21124_((MobEffect)ModEffectsRegistry.GROTESQUE_WARD.get()).m_19564_();
                        amplifier = (int)Math.min((float)(amplifier + 1), effect.getGrotesqueMaxAuraWard());
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.GROTESQUE_WARD.get(), 50, amplifier));
                        continue;
                    }
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.GROTESQUE_WARD.get(), 50, 0));
                }
            }
        }
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123762_, ParticleTypes.f_123762_, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237110_((String)"item.simplymore.blade_of_the_grotesque.tooltip5", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(this.skillLength)}).m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip6").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip7").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.blade_of_the_grotesque.tooltip8").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

