/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.entity.BlackPearlFireballEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BlackPearlItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getBlackPearlCannonballCooldown();
    int plunderChance = effect.getBlackPearlPlunderChance();
    int stepMod = 0;

    public BlackPearlItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<MobEffectInstance> positiveEffects;
        int randomNumber;
        if (!attacker.m_9236_().m_5776_() && (randomNumber = attacker.m_217043_().m_216332_(1, 100)) <= this.plunderChance && !(positiveEffects = target.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL).toList()).isEmpty()) {
            MobEffectInstance plunderedEffect = positiveEffects.get(attacker.m_217043_().m_188503_(positiveEffects.size()));
            int amplifier = Math.min(plunderedEffect.m_19564_(), 4);
            int duration = Math.min(plunderedEffect.m_19557_(), 600);
            if (plunderedEffect.m_19557_() == -1) {
                duration = 600;
            }
            MobEffectInstance newEffect = new MobEffectInstance(plunderedEffect.m_19544_(), duration, amplifier);
            attacker.m_7292_(newEffect);
            target.m_21195_(plunderedEffect.m_19544_());
            attacker.m_9236_().m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.DARK_SWORD_BLOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            float velocityPower = 3.0f;
            float yawRadians = (float)Math.toRadians(user.m_146908_() + 90.0f);
            float pitchRadians = (float)Math.toRadians(user.m_146909_());
            float velocityX = (float)(Math.cos(yawRadians) * Math.cos(pitchRadians)) * velocityPower;
            float velocityZ = (float)(Math.sin(yawRadians) * Math.cos(pitchRadians)) * velocityPower;
            float velocityY = (float)Math.sin(pitchRadians) * -velocityPower;
            BlackPearlFireballEntity fireballEntity = new BlackPearlFireballEntity(world, (LivingEntity)user, velocityX, velocityY, velocityZ);
            fireballEntity.m_20343_(user.m_20185_() + (double)(velocityX / 2.0f), user.m_20188_() + (double)(velocityY / 2.0f), user.m_20189_() + (double)(velocityZ / 2.0f));
            world.m_7967_((Entity)fireballEntity);
            user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, ParticleTypes.f_123781_, ParticleTypes.f_123781_, ParticleTypes.f_123783_);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        Style abilityStyle = HelperMethods.getStyle((String)"ability");
        Style textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.black_pearl.tooltip1").m_6270_(abilityStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.black_pearl.tooltip2").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.black_pearl.tooltip3").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(rightClickStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.black_pearl.tooltip4").m_6270_(textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.black_pearl.tooltip5").m_6270_(textStyle));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

