/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.interfaces;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface CooldownOnUnselected {
    public static final String nbt = "simplymore:using";
    public static final String offhand = "simplymore:offhand";
    public static final String previous_offhand = "simplymore:previous_offhand";

    default public void cooldown(Player user, int time) {
        user.m_21253_();
        user.m_36335_().m_41524_((Item)this, time);
    }

    default public void startUsing(ItemStack stack, InteractionHand hand) {
        stack.m_41784_().m_128379_(nbt, true);
        if (this.getOffhand(stack) != null) {
            stack.m_41784_().m_128379_(previous_offhand, this.getOffhand(stack).booleanValue());
        }
        stack.m_41784_().m_128379_(offhand, hand == InteractionHand.OFF_HAND);
    }

    default public Boolean getUsing(ItemStack stack) {
        if (stack.m_41784_().m_128441_(nbt)) {
            return stack.m_41784_().m_128471_(nbt);
        }
        return null;
    }

    default public Boolean getOffhand(ItemStack stack) {
        if (stack.m_41784_().m_128441_(offhand)) {
            return stack.m_41784_().m_128471_(offhand);
        }
        return null;
    }

    default public boolean checkIfHandChanged(ItemStack stack) {
        if (stack.m_41784_().m_128441_(offhand) && stack.m_41784_().m_128441_(previous_offhand)) {
            return stack.m_41784_().m_128471_(previous_offhand) != stack.m_41784_().m_128471_(offhand);
        }
        return false;
    }

    default public void endUsing(ItemStack stack) {
        stack.m_41784_().m_128379_(nbt, false);
        stack.m_41784_().m_128473_(previous_offhand);
        stack.m_41784_().m_128473_(offhand);
    }

    default public void detectCooldown(Player user, boolean selected, ItemStack stack, int time, boolean twoHanded) {
        if (user.m_36335_().m_41519_((Item)this)) {
            this.endUsing(stack);
            return;
        }
        if (!twoHanded) {
            selected = !this.checkIfHandChanged(stack) ? selected || user.m_21206_() == stack : false;
        }
        if (selected || !Boolean.TRUE.equals(this.getUsing(stack))) {
            return;
        }
        this.cooldown(user, time);
        this.endUsing(stack);
    }
}

