/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.entity;

import java.util.List;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import org.jetbrains.annotations.Nullable;

public class GhostFallingBlockEntity
extends FallingBlockEntity
implements TraceableEntity {
    public Entity owner;
    protected static WrapperConfig config = (WrapperConfig)AutoConfig.getConfigHolder(WrapperConfig.class).getConfig();
    protected static UniqueEffectConfig effect = GhostFallingBlockEntity.config.uniqueEffects;

    public GhostFallingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level world) {
        super(entityType, world);
    }

    public GhostFallingBlockEntity(Level world, double x, double y, double z, Vec3 velocity, LivingEntity owner) {
        this((EntityType<? extends FallingBlockEntity>)EntityType.f_20450_, world);
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(velocity);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.f_31943_ = false;
        this.owner = owner;
        this.m_31959_(this.m_20183_());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.m_19749_() != null) {
            nbt.m_128362_("Owner", this.m_19749_().m_20148_());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128403_("Owner")) {
            UUID uUID = nbt.m_128342_("Owner");
            this.owner = ((ServerLevel)this.m_9236_()).m_8791_(uUID);
        }
    }

    public void m_149650_(Block block, BlockPos pos) {
        if (block instanceof Fallable) {
            this.destroy();
        }
    }

    public void destroy() {
        this.m_5496_(SoundEvents.f_12442_, 1.0f, 1.0f);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.25, 0.25, 0.25, 0.5);
        this.m_146870_();
    }

    public void m_8119_() {
        ++this.f_31942_;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            BlockPos blockPos = this.m_20183_();
            if (this.m_20096_()) {
                this.destroy();
            } else if (!(this.m_9236_().f_46443_ || (this.f_31942_ <= 100 || blockPos.m_123342_() > this.m_9236_().m_141937_() && blockPos.m_123342_() <= this.m_9236_().m_151558_()) && this.f_31942_ <= 600)) {
                this.destroy();
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        AABB box = new AABB(this.m_20185_() + 0.75, this.m_20186_() + 0.75, this.m_20189_() + 0.75, this.m_20185_() - 0.75, this.m_20186_() - 0.75, this.m_20189_() - 0.75);
        List livingEntities = this.m_9236_().m_45976_(LivingEntity.class, box);
        Entity ownerEntity = this.m_19749_();
        if (ownerEntity == null) {
            return;
        }
        List<LivingEntity> targets = livingEntities.stream().filter(livingEntity -> {
            TraceableEntity pet;
            return livingEntity != ownerEntity && !livingEntity.m_7307_(ownerEntity) && (!(livingEntity instanceof TraceableEntity) || (pet = (TraceableEntity)livingEntity).m_19749_() != ownerEntity);
        }).toList();
        targets.forEach(target -> {
            target.m_6469_(this.m_269291_().m_269564_((Entity)this), effect.getExedrillRockDamage());
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.STUNNED.get(), effect.getExedrillRockStunTime()));
        });
        if (!targets.isEmpty()) {
            this.destroy();
        }
    }

    @Nullable
    public Entity m_19749_() {
        return this.owner;
    }
}

