/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.entity;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.item.uniques.DeathsEyrieItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CrowEntity
extends TamableAnimal
implements TraceableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> ATTACKING_UUID = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<OptionalInt> ATTACKING_TIME = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private Player owner;
    public final AnimationState flapAnimationState = new AnimationState();
    protected static WrapperConfig config = (WrapperConfig)AutoConfig.getConfigHolder(WrapperConfig.class).getConfig();
    protected static UniqueEffectConfig effect = CrowEntity.config.uniqueEffects;

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 3.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING_UUID, Optional.empty());
        this.f_19804_.m_135372_(ATTACKING_TIME, (Object)OptionalInt.of(0));
    }

    public CrowEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, false);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    public UUID getAttackingUuid() {
        if (((Optional)this.m_20088_().m_135370_(ATTACKING_UUID)).isPresent()) {
            return (UUID)((Optional)this.m_20088_().m_135370_(ATTACKING_UUID)).get();
        }
        return null;
    }

    public int getAttackingTime() {
        if (((OptionalInt)this.m_20088_().m_135370_(ATTACKING_TIME)).isPresent()) {
            return ((OptionalInt)this.m_20088_().m_135370_(ATTACKING_TIME)).getAsInt();
        }
        return 0;
    }

    public void setAttackingTime(int value) {
        this.m_20088_().m_276349_(ATTACKING_TIME, (Object)OptionalInt.of(value), true);
    }

    public void setAttackingUuid(UUID value) {
        this.m_20088_().m_276349_(ATTACKING_UUID, Optional.of(value), true);
    }

    public void m_8119_() {
        super.m_8119_();
        Player player = (Player)this.m_269323_();
        if (player != null) {
            if (player.m_36335_().m_41519_((Item)ModItemsRegistry.DEATHS_EYRIE.get())) {
                if (this.getAttackingTime() >= -1) {
                    this.m_20242_(true);
                    this.m_147244_(true);
                    this.f_21345_.m_148105_().clear();
                    this.f_21346_.m_148105_().clear();
                    int time = this.getAttackingTime();
                    this.setAttackingTime(time - 1);
                    LivingEntity target = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.getAttackingUuid());
                    if (target == null || target.m_21224_()) {
                        this.m_6074_();
                        return;
                    }
                    if (time % 10 == 0) {
                        float dX = (float)this.m_217043_().m_216332_(-10, 10) / 10.0f;
                        float dY = (float)this.m_217043_().m_216332_(-10, 10) / 10.0f;
                        float dZ = (float)this.m_217043_().m_216332_(-10, 10) / 10.0f;
                        this.teleportWithParticles(target.m_20185_() + (double)dX, target.m_20188_() + 1.0 + (double)dY, target.m_20189_() + (double)dZ);
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        this.m_21195_(MobEffects.f_19609_);
                        this.m_20256_(new Vec3((double)dX * -0.5, ((double)dY + 1.25) * -0.5, (double)dZ * -0.5));
                    } else if (time % 10 == 5) {
                        double originalResistance = target.m_21133_(Attributes.f_22278_);
                        if (target.m_21051_(Attributes.f_22278_) != null) {
                            target.m_21051_(Attributes.f_22278_).m_22100_(1.0);
                        }
                        target.m_6469_(this.owner.m_269291_().m_269075_(this.owner), effect.getDeathsEyrieCrowAttackDamage());
                        this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 10, 0, true, false));
                        this.owner.m_5634_(effect.getDeathsEyrieCrowAttackHeal());
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effect.getDeathsEyrieCrowAttackBlindTime()));
                        target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effect.getDeathsEyrieCrowAttackBleedTime()));
                        if (target.m_21051_(Attributes.f_22278_) != null) {
                            target.m_21051_(Attributes.f_22278_).m_22100_(originalResistance);
                        }
                    }
                } else {
                    this.m_6074_();
                }
            } else if (player.m_21224_() || player.m_9236_().m_6042_() != this.m_9236_().m_6042_() || !(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof DeathsEyrieItem)) {
                this.m_6074_();
            }
        } else {
            this.m_6074_();
        }
        if (this.m_9236_().m_5776_() && !this.m_20096_() && this.f_19797_ % 3 == 0) {
            this.flapAnimationState.m_216977_(this.f_19797_);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (((Optional)this.f_19804_.m_135370_(ATTACKING_UUID)).isPresent()) {
            nbt.m_128362_("AttackingUUID", (UUID)((Optional)this.f_19804_.m_135370_(ATTACKING_UUID)).get());
        }
        if (((OptionalInt)this.f_19804_.m_135370_(ATTACKING_TIME)).isPresent()) {
            nbt.m_128405_("AttackingTime", ((OptionalInt)this.f_19804_.m_135370_(ATTACKING_TIME)).getAsInt());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128403_("AttackingUUID")) {
            this.f_19804_.m_135381_(ATTACKING_UUID, Optional.of(nbt.m_128342_("AttackingUUID")));
        } else {
            this.f_19804_.m_135381_(ATTACKING_UUID, Optional.empty());
        }
        if (nbt.m_128441_("AttackingTime")) {
            this.f_19804_.m_135381_(ATTACKING_TIME, (Object)OptionalInt.of(nbt.m_128451_("AttackingTime")));
        } else {
            this.f_19804_.m_135381_(ATTACKING_TIME, (Object)OptionalInt.empty());
        }
    }

    public void teleportWithParticles(double x, double y, double z) {
        this.m_20324_(x, y, z);
        this.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_12259_, SoundSource.NEUTRAL, 1.0f, 0.6f);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.2f), 1.0f), x, y, z, 5, (double)0.2f, (double)0.2f, (double)0.2f, 0.0);
    }

    public void m_6667_(DamageSource damageSource) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12259_, SoundSource.NEUTRAL, 1.0f, 0.6f);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.2f), 3.0f), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 5, (double)0.2f, (double)0.2f, (double)0.2f, 0.0);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source != this.m_269291_().m_287172_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6087_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public EntityGetter m_9236_() {
        return null;
    }

    public LivingEntity m_269323_() {
        return this.owner;
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(true);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public void m_21828_(Player player) {
        this.owner = player;
    }
}

