/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class TidebreakerEffect
extends MobEffect {
    public TidebreakerEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity affectedEntity, int amplifier) {
        if (!affectedEntity.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)affectedEntity.m_9236_();
            this.spawnParticles(serverWorld, affectedEntity);
            this.playRainSound(serverWorld, affectedEntity);
            this.applyInsanityEffect(affectedEntity, serverWorld);
        }
        super.m_6742_(affectedEntity, amplifier);
    }

    private void spawnParticles(ServerLevel serverWorld, LivingEntity affectedEntity) {
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123796_, affectedEntity.m_20185_(), affectedEntity.m_20186_() + 5.0, affectedEntity.m_20189_(), 100, 3.0, 0.0, 3.0, 0.05);
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123804_, affectedEntity.m_20185_(), affectedEntity.m_20186_() + 5.0, affectedEntity.m_20189_(), 100, 3.0, 0.0, 3.0, 0.0);
    }

    private void playRainSound(ServerLevel serverWorld, LivingEntity affectedEntity) {
        if (serverWorld.m_46467_() % 5L == 0L) {
            serverWorld.m_6263_(null, affectedEntity.m_20185_(), affectedEntity.m_20186_(), affectedEntity.m_20189_(), SoundEvents.f_12541_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void applyInsanityEffect(LivingEntity affectedEntity, ServerLevel serverWorld) {
        for (LivingEntity target : serverWorld.m_45976_(LivingEntity.class, new AABB(affectedEntity.m_20185_() - 3.0, affectedEntity.m_20186_() - 2.0, affectedEntity.m_20189_() - 3.0, affectedEntity.m_20185_() + 3.0, affectedEntity.m_20186_() + 8.0, affectedEntity.m_20189_() + 3.0))) {
            if (target == affectedEntity || target.m_7307_((Entity)affectedEntity)) continue;
            target.m_147207_(new MobEffectInstance((MobEffect)ModEffectsRegistry.INSANITY.get(), 160, 0), (Entity)affectedEntity);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

