/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.effect;

import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.entity.KickbackAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.uniques.RevvengineItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class RevvengineRushEffect
extends MobEffect {
    protected static WrapperConfig config = (WrapperConfig)AutoConfig.getConfigHolder(WrapperConfig.class).getConfig();
    protected static UniqueEffectConfig effect = RevvengineRushEffect.config.uniqueEffects;

    public RevvengineRushEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        super.m_6742_(entity, amplifier);
        if (entity.f_19797_ % 2 == 0) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.MAGIC_BOW_PULL_BACK_SHORT_VERSION_02.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
        }
        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(entity.m_146908_());
        entity.m_20334_(normalisedVector.x() * 0.6, entity.m_20184_().m_7098_(), normalisedVector.z() * 0.6);
        entity.f_19864_ = true;
        if (!entity.m_9236_().f_46443_) {
            if (amplifier > 0) {
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 10, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.3f);
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 3, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.3f);
            } else {
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.5f, 0.5f), 1.0f), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 5, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.3f);
            }
        }
        Vec3 position = entity.m_146892_();
        Vec3 particlePos = new Vec3(position.m_7096_() + normalisedVector.x(), position.m_7098_(), position.m_7094_() + normalisedVector.z());
        AABB box = new AABB(particlePos.m_7096_() - 1.0, particlePos.m_7098_() - 1.0, particlePos.m_7094_() - 1.0, particlePos.m_7096_() + 1.0, particlePos.m_7098_() + 1.0, particlePos.m_7094_() + 1.0);
        List<LivingEntity> entities = entity.m_9236_().m_45976_(LivingEntity.class, box).stream().filter(livingEntity -> livingEntity != entity && !livingEntity.m_7307_((Entity)entity)).toList();
        if (!entities.isEmpty()) {
            if (amplifier > 0) {
                this.causeSlash(entity, effect.getRevvenginePhase3EffectTime(), effect.getRevvenginePhase3Damage(), true);
            } else {
                this.causeSlash(entity, effect.getRevvenginePhase2EffectTime(), effect.getRevvenginePhase2Damage(), false);
            }
        }
        if (entity.m_21023_((MobEffect)this) && entity.m_21124_((MobEffect)this).m_19557_() < 10) {
            if (amplifier > 0) {
                this.causeSlash(entity, effect.getRevvenginePhase3EffectTime(), effect.getRevvenginePhase3Damage(), true);
            } else {
                this.causeSlash(entity, effect.getRevvenginePhase2EffectTime(), effect.getRevvenginePhase2Damage(), false);
            }
        }
        if (amplifier > 0 && entity.f_19797_ % 5 == 0) {
            entity.m_9236_().m_7967_((Entity)new KickbackAreaEffectCloudEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20188_() - 0.5, entity.m_20189_(), 1, entity));
        }
    }

    public void causeSlash(LivingEntity user, int effectTime, float damage, boolean isTier3) {
        if (user.m_9236_().f_46443_) {
            return;
        }
        user.m_21195_((MobEffect)this);
        Vec3 position = user.m_146892_();
        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(user.m_146908_());
        Vec3 particlePos = new Vec3(position.m_7096_() + normalisedVector.x(), position.m_7098_(), position.m_7094_() + normalisedVector.z());
        AABB box = new AABB(particlePos.m_7096_() - 1.0, particlePos.m_7098_() - 1.0, particlePos.m_7094_() - 1.0, particlePos.m_7096_() + 1.0, particlePos.m_7098_() + 1.0, particlePos.m_7094_() + 1.0);
        for (LivingEntity livingEntity : user.m_9236_().m_45976_(LivingEntity.class, box)) {
            if (livingEntity.m_7307_((Entity)user) || livingEntity == user || livingEntity.m_20147_()) continue;
            livingEntity.m_6469_(user.m_269291_().m_269075_((Player)user), RevvengineItem.getHealthModifiedValue(user, effect.getRevvengineMaxDamagePercentageBuff(), damage) + damage);
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), effectTime, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effectTime, 0));
            if (isTier3) {
                livingEntity.m_20254_(effectTime / 20);
            }
            user.m_9236_().m_6263_(null, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.5f);
            ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

