/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class MistyEffect
extends MobEffect {
    public MistyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity affectedEntity, int amplifier) {
        if (!affectedEntity.m_21023_((MobEffect)this)) {
            return;
        }
        int effectDuration = affectedEntity.m_21124_((MobEffect)this).m_19557_();
        if (effectDuration >= 9960 && effectDuration < 9990 && !affectedEntity.m_9236_().f_46443_ && affectedEntity instanceof Player) {
            Player playerEntity = (Player)affectedEntity;
            float playerYaw = (float)Math.toRadians(playerEntity.m_146908_() + 90.0f);
            float playerPitch = (float)Math.toRadians(playerEntity.m_146909_());
            float forwardDirectionX = (float)(Math.cos(playerYaw) * Math.cos(playerPitch));
            float forwardDirectionZ = (float)(Math.sin(playerYaw) * Math.cos(playerPitch));
            float forwardDirectionY = (float)Math.sin(playerPitch) * -1.0f;
            LivingEntity teleportTarget = this.findTeleportTarget(playerEntity, forwardDirectionX, forwardDirectionY, forwardDirectionZ);
            if (teleportTarget != null) {
                playerEntity.m_21195_((MobEffect)this);
                double distanceToTarget = Math.sqrt(Math.pow(playerEntity.m_20185_() - teleportTarget.m_20185_(), 2.0) + Math.pow(playerEntity.m_20186_() - teleportTarget.m_20186_(), 2.0) + Math.pow(playerEntity.m_20189_() - teleportTarget.m_20189_(), 2.0));
                this.spawnParticles(playerEntity, forwardDirectionX, forwardDirectionY, forwardDirectionZ, distanceToTarget /= 10.0);
                playerEntity.m_20324_(teleportTarget.m_20185_(), teleportTarget.m_20186_(), teleportTarget.m_20182_().m_7094_());
            }
        }
        if (affectedEntity.m_20096_() && effectDuration < 9980) {
            affectedEntity.m_21195_((MobEffect)this);
        }
        if (!affectedEntity.m_9236_().f_46443_) {
            ((ServerLevel)affectedEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, affectedEntity.m_20185_(), affectedEntity.m_20186_() + 0.5, affectedEntity.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
        }
        affectedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5));
        affectedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5));
        super.m_6742_(affectedEntity, amplifier);
    }

    private LivingEntity findTeleportTarget(Player player, float offsetDirectionX, float offsetDirectionY, float offsetDirectionZ) {
        LivingEntity teleportTarget = null;
        double boxSize = 1.3;
        for (int i = 10; i > 0; --i) {
            double x = player.m_20185_() + (double)(offsetDirectionX * (float)i);
            double y = player.m_20186_() + (double)(offsetDirectionY * (float)i);
            double z = player.m_20189_() + (double)(offsetDirectionZ * (float)i);
            for (LivingEntity target : player.m_20193_().m_45976_(LivingEntity.class, new AABB(x - boxSize, y - boxSize, z - boxSize, x + boxSize, y + boxSize, z + boxSize))) {
                if (!player.m_142582_((Entity)target) || target == player || target.m_7307_((Entity)player) || teleportTarget != null) continue;
                teleportTarget = target;
                int amplifier = (int)Math.ceil(target.m_21233_() / 5.0f);
                if (amplifier > 20) {
                    amplifier = 20;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.WITHERING_FATE.get(), 600, --amplifier));
                target.m_6469_(player.m_269291_().m_269075_(player), 8.0f);
            }
        }
        return teleportTarget;
    }

    private void spawnParticles(Player player, float offsetDirectionX, float offsetDirectionY, float offsetDirectionZ, double lineBetweenPlayerAndTarget) {
        for (int i = 0; i < 10; ++i) {
            double x = player.m_20185_() + (double)(offsetDirectionX * (float)i) * lineBetweenPlayerAndTarget;
            double y = player.m_20186_() + (double)(offsetDirectionY * (float)i) * lineBetweenPlayerAndTarget;
            double z = player.m_20189_() + (double)(offsetDirectionZ * (float)i) * lineBetweenPlayerAndTarget;
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, y, z, 10, 0.2, 0.2, 0.2, 0.2);
            player.m_9236_().m_6263_(null, x, y, z, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_01.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

