/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rosemarythyme.simplymore.client.models.CrowEntityModel;
import net.rosemarythyme.simplymore.client.renderers.CrowEntityRenderer;
import net.rosemarythyme.simplymore.registry.ModEntityRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;

@OnlyIn(value=Dist.CLIENT)
public class SimplyMoreClientInit {
    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(ModEntityRegistry.CROW, CrowEntityRenderer::new);
        EntityModelLayerRegistry.register((ModelLayerLocation)CrowEntityModel.CROW_LAYER, CrowEntityModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntityRegistry.GHOST_FALLING_BLOCK, FallingBlockRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModelPredicates() {
        int[] randomSprite = new int[]{0};
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItemsRegistry.TIMEKEEPER.get()), (ResourceLocation)new ResourceLocation("simplymore", "sun"), (itemStack, clientWorld, livingEntity, a) -> {
            if (clientWorld == null) {
                return 0.0f;
            }
            long dayTime = Math.abs(clientWorld.m_46468_() % 24000L);
            boolean fixedTime = clientWorld.m_6042_().m_63967_();
            if (fixedTime) {
                randomSprite[0] = clientWorld.m_213780_().m_188499_() ? randomSprite[0] + 1 : randomSprite[0] - 1;
                randomSprite[0] = randomSprite[0] + 14;
                randomSprite[0] = randomSprite[0] % 14;
                return (float)randomSprite[0] / 100.0f;
            }
            if (dayTime < 250L) {
                return 0.11f;
            }
            if (dayTime < 750L) {
                return 0.12f;
            }
            if (dayTime < 1250L) {
                return 0.13f;
            }
            if (dayTime < 11250L) {
                return 0.0f;
            }
            if (dayTime < 11750L) {
                return 0.01f;
            }
            if (dayTime < 12250L) {
                return 0.02f;
            }
            if (dayTime < 12750L) {
                return 0.03f;
            }
            if (dayTime < 13250L) {
                return 0.04f;
            }
            if (dayTime < 13750L) {
                return 0.05f;
            }
            if (dayTime < 14250L) {
                return 0.06f;
            }
            if (dayTime < 22250L) {
                return 0.07f;
            }
            if (dayTime < 22750L) {
                return 0.08f;
            }
            if (dayTime < 23250L) {
                return 0.09f;
            }
            if (dayTime < 23750L) {
                return 0.1f;
            }
            return 0.11f;
        });
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItemsRegistry.MATTERBANE.get()), (ResourceLocation)new ResourceLocation("simplymore", "color"), (itemStack, clientWorld, livingEntity, a) -> {
            Object color = itemStack.m_41784_().m_128423_("simplymore:color");
            color = SimplyMoreHelperMethods.getMatterbaneColor(color);
            color = Float.valueOf(((Integer)color).intValue());
            return ((Float)color).floatValue() / 100.0f;
        });
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItemsRegistry.BRASSTURN.get()), (ResourceLocation)new ResourceLocation("simplymore", "oxidisation"), (itemStack, clientWorld, livingEntity, a) -> {
            int oxidisation = SimplyMoreHelperMethods.getBrassturnOxidisation(itemStack);
            if (oxidisation >= 16) {
                return 0.3f;
            }
            if (oxidisation >= 11) {
                return 0.2f;
            }
            if (oxidisation >= 6) {
                return 0.1f;
            }
            return 0.0f;
        });
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItemsRegistry.DEATHS_EYRIE.get()), (ResourceLocation)new ResourceLocation("simplymore", "crows"), (itemStack, clientWorld, livingEntity, a) -> (float)SimplyMoreHelperMethods.getDeathsEyrieCrows(itemStack) * 0.1f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItemsRegistry.RUYI_JINGU_BANG.get()), (ResourceLocation)new ResourceLocation("simplymore", "size"), (itemStack, clientWorld, livingEntity, a) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            if (livingEntity.m_21211_() != itemStack) {
                return 0.0f;
            }
            int itemUseTime = livingEntity.m_21252_();
            if (itemUseTime < 20) {
                return 0.0f;
            }
            if (itemUseTime < 40) {
                return 0.1f;
            }
            if (itemUseTime < 60) {
                return 0.2f;
            }
            if (itemUseTime < 80) {
                return 0.3f;
            }
            if (itemUseTime < 100) {
                return 0.4f;
            }
            if (itemUseTime < 120) {
                return 0.5f;
            }
            if (itemUseTime < 140) {
                return 0.6f;
            }
            if (itemUseTime < 160) {
                return 0.7f;
            }
            if (itemUseTime < 180) {
                return 0.8f;
            }
            if (itemUseTime < 200) {
                return 0.9f;
            }
            return 1.0f;
        });
    }
}

