/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.chunkio.mixin;

import com.ishland.c2me.threading.chunkio.common.ChunkIoThreadingExecutorUtils;
import com.ishland.c2me.threading.chunkio.common.IAsyncChunkStorage;
import java.util.BitSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IOWorker.class})
public abstract class MixinStorageIoWorker
implements IAsyncChunkStorage {
    @Shadow
    @Final
    private static Logger f_63515_;
    private ExecutorService threadExecutor;

    @Shadow
    public abstract CompletableFuture<Optional<CompoundTag>> m_156587_(ChunkPos var1);

    @Shadow
    protected abstract boolean m_223484_(CompoundTag var1);

    @Shadow
    public abstract CompletableFuture<Void> m_196358_(ChunkPos var1, StreamTagVisitor var2);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Util;getIoWorkerExecutor()Ljava/util/concurrent/ExecutorService;"))
    private ExecutorService redirectIoWorkerExecutor() {
        this.threadExecutor = Executors.newSingleThreadExecutor(ChunkIoThreadingExecutorUtils.ioWorkerFactory);
        return this.threadExecutor;
    }

    @Override
    public CompletableFuture<Optional<CompoundTag>> getNbtAtAsync(ChunkPos pos) {
        return this.m_156587_(pos);
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/thread/TaskExecutor;close()V", shift=At.Shift.AFTER)})
    private void onClose(CallbackInfo ci) {
        this.threadExecutor.shutdown();
        while (!this.threadExecutor.isTerminated()) {
            LockSupport.parkNanos("Waiting for thread executor termination", 100000L);
        }
    }

    @Overwrite
    private CompletableFuture<BitSet> m_223489_(int chunkX, int chunkZ) {
        ChunkPos chunkPos = ChunkPos.m_220337_((int)chunkX, (int)chunkZ);
        ChunkPos chunkPos2 = ChunkPos.m_220340_((int)chunkX, (int)chunkZ);
        BitSet bitSet = new BitSet();
        CompletableFuture[] futures = (CompletableFuture[])ChunkPos.m_45599_((ChunkPos)chunkPos, (ChunkPos)chunkPos2).map(chunkPosx -> {
            CollectFields selectiveNbtCollector = new CollectFields(new FieldSelector[]{new FieldSelector(IntTag.f_128670_, "DataVersion"), new FieldSelector(CompoundTag.f_128326_, "blending_data")});
            return ((CompletableFuture)this.m_196358_((ChunkPos)chunkPosx, (StreamTagVisitor)selectiveNbtCollector).thenRun(() -> {
                CompoundTag nbtCompound;
                Tag nbtElement = selectiveNbtCollector.m_197713_();
                if (nbtElement instanceof CompoundTag && this.m_223484_(nbtCompound = (CompoundTag)nbtElement)) {
                    int i = chunkPosx.m_45614_() * 32 + chunkPosx.m_45613_();
                    BitSet bitSet2 = bitSet;
                    synchronized (bitSet2) {
                        bitSet.set(i);
                    }
                }
            })).exceptionally(throwable -> {
                f_63515_.warn("Failed to scan chunk {}", chunkPosx, throwable);
                return null;
            });
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(unused -> bitSet);
    }
}

