/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.chunkio.mixin;

import com.ishland.c2me.base.mixin.access.IBlender;
import com.ishland.c2me.threading.chunkio.common.ProtoChunkExtension;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ProtoChunk.class})
public class MixinProtoChunk
implements ProtoChunkExtension {
    @Unique
    private CompletableFuture<Void> blendingComputeFuture = CompletableFuture.completedFuture(null);
    @Unique
    private CompletableFuture<Void> initialMainThreadComputeFuture = CompletableFuture.completedFuture(null);
    @Unique
    private boolean needBlending = false;

    @Override
    public void setBlendingInfo(ChunkPos pos, List<BitSet> bitSets) {
        int radius = IBlender.getBLENDING_CHUNK_DISTANCE_THRESHOLD();
        int width = radius * 2 + 1;
        ChunkPos chunkPos2 = new ChunkPos(pos.f_45578_ - radius, pos.f_45579_ - radius);
        ChunkPos chunkPos3 = new ChunkPos(pos.f_45578_ + radius, pos.f_45579_ + radius);
        int index = 0;
        for (int i = chunkPos2.m_45610_(); i <= chunkPos3.m_45610_(); ++i) {
            for (int j = chunkPos2.m_45612_(); j <= chunkPos3.m_45612_(); ++j) {
                BitSet bitSet;
                if ((bitSet = bitSets.get(index++)).isEmpty()) continue;
                ChunkPos chunkPos4 = ChunkPos.m_220337_((int)i, (int)j);
                int k = Math.max(chunkPos2.f_45578_ - chunkPos4.f_45578_, 0);
                int l = Math.max(chunkPos2.f_45579_ - chunkPos4.f_45579_, 0);
                int m = Math.min(chunkPos3.f_45578_ - chunkPos4.f_45578_, 31);
                int n = Math.min(chunkPos3.f_45579_ - chunkPos4.f_45579_, 31);
                for (int o = k; o <= m; ++o) {
                    for (int p = l; p <= n; ++p) {
                        int q = p * 32 + o;
                        if (!bitSet.get(q)) continue;
                        this.needBlending = true;
                        return;
                    }
                }
            }
        }
        this.needBlending = false;
    }

    @Override
    public void setBlendingComputeFuture(CompletableFuture<Void> future) {
        this.blendingComputeFuture = future;
    }

    @Override
    public boolean getNeedBlending() {
        if (!this.blendingComputeFuture.isDone()) {
            this.blendingComputeFuture.join();
        }
        return this.needBlending;
    }

    @Override
    public void setInitialMainThreadComputeFuture(CompletableFuture<Void> future) {
        this.initialMainThreadComputeFuture = future;
    }

    @Override
    public CompletableFuture<Void> getInitialMainThreadComputeFuture() {
        return this.initialMainThreadComputeFuture;
    }
}

