/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.chunkio.mixin;

import com.ishland.c2me.threading.chunkio.common.AsyncSerializationManager;
import com.ishland.c2me.threading.chunkio.common.ChunkIoMainThreadTaskUtils;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ChunkSerializer.class})
public class MixinChunkSerializer {
    @Shadow
    @Final
    private static Logger f_63449_;

    @Redirect(method={"deserialize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;initForPalette(Lnet/minecraft/util/math/ChunkSectionPos;Lnet/minecraft/world/chunk/ChunkSection;)V"))
    private static void onPoiStorageInitForPalette(PoiManager instance, SectionPos chunkSectionPos, LevelChunkSection chunkSection) {
        ChunkIoMainThreadTaskUtils.executeMain(() -> instance.m_280570_(chunkSectionPos, chunkSection));
    }

    @Redirect(method={"serialize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getBlockEntityPositions()Ljava/util/Set;"))
    private static Set<BlockPos> onChunkGetBlockEntityPositions(ChunkAccess chunk) {
        AsyncSerializationManager.Scope scope = AsyncSerializationManager.getScope(chunk.m_7697_());
        return scope != null ? scope.blockEntityPositions : chunk.m_5928_();
    }

    @Redirect(method={"serialize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getPackedBlockEntityNbt(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/nbt/NbtCompound;"))
    private static CompoundTag onChunkGetPackedBlockEntityNbt(ChunkAccess chunk, BlockPos pos) {
        AsyncSerializationManager.Scope scope = AsyncSerializationManager.getScope(chunk.m_7697_());
        if (scope == null) {
            return chunk.m_8051_(pos);
        }
        BlockEntity blockEntity = scope.blockEntities.get(pos);
        if (blockEntity != null) {
            CompoundTag nbtCompound = blockEntity.m_187480_();
            if (chunk instanceof LevelChunk) {
                nbtCompound.m_128379_("keepPacked", false);
            }
            return nbtCompound;
        }
        CompoundTag nbtCompound = scope.pendingBlockEntityNbtsPacked.get(pos);
        if (nbtCompound != null && chunk instanceof LevelChunk) {
            nbtCompound.m_128379_("keepPacked", true);
        }
        if (nbtCompound == null && AsyncSerializationManager.DEBUG) {
            f_63449_.warn("Block Entity at {} for block {} doesn't exist", (Object)pos, (Object)chunk.m_8055_(pos).m_60734_());
        }
        return nbtCompound;
    }

    @Redirect(method={"serialize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/LightingProvider;get(Lnet/minecraft/world/LightType;)Lnet/minecraft/world/chunk/light/ChunkLightingView;"))
    private static LayerLightEventListener onLightingProviderGet(LevelLightEngine lightingProvider, LightLayer lightType) {
        AsyncSerializationManager.Scope scope = AsyncSerializationManager.getScope(null);
        return scope != null ? scope.lighting.get(lightType) : lightingProvider.m_75814_(lightType);
    }
}

