/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.chunkio.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSerializationManager {
    public static final boolean DEBUG = Boolean.getBoolean("c2me.chunkio.debug");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Async Serialization Manager");
    private static final ThreadLocal<ArrayDeque<Scope>> scopeHolder = ThreadLocal.withInitial(ArrayDeque::new);

    public static void push(Scope scope) {
        scopeHolder.get().push(scope);
    }

    public static Scope getScope(ChunkPos pos) {
        Scope scope = scopeHolder.get().peek();
        if (pos == null) {
            return scope;
        }
        if (scope != null) {
            if (scope.pos.equals((Object)pos)) {
                return scope;
            }
            LOGGER.error("Scope position mismatch! Expected: {} but got {}. This will impact stability. Incompatible mods?", new Object[]{scope.pos, pos, new Throwable()});
        }
        return null;
    }

    public static void pop(Scope scope) {
        if (scope != scopeHolder.get().peek()) {
            throw new IllegalArgumentException("Scope mismatch");
        }
        scopeHolder.get().pop();
    }

    public static class Scope {
        public final ChunkPos pos;
        public final Map<LightLayer, LayerLightEventListener> lighting;
        public final Set<BlockPos> blockEntityPositions;
        public final Map<BlockPos, BlockEntity> blockEntities;
        public final Map<BlockPos, CompoundTag> pendingBlockEntityNbtsPacked;
        private final AtomicBoolean isOpen = new AtomicBoolean(false);

        public Scope(ChunkAccess chunk, ServerLevel world) {
            this.pos = chunk.m_7697_();
            this.lighting = Arrays.stream(LightLayer.values()).map(type -> new CachedLightingView(world.m_5518_(), chunk.m_7697_(), (LightLayer)type)).collect(Collectors.toMap(CachedLightingView::getLightType, Function.identity()));
            this.blockEntityPositions = chunk.m_5928_();
            this.blockEntities = this.blockEntityPositions.stream().map(arg_0 -> ((ChunkAccess)chunk).m_7702_(arg_0)).filter(Objects::nonNull).filter(blockEntity -> !blockEntity.m_58901_()).collect(Collectors.toMap(BlockEntity::m_58899_, Function.identity()));
            Object2ObjectOpenHashMap pendingBlockEntitiesNbtPacked = new Object2ObjectOpenHashMap();
            for (BlockPos blockPos : this.blockEntityPositions) {
                CompoundTag blockEntityNbt = chunk.m_8049_(blockPos);
                if (blockEntityNbt == null) continue;
                CompoundTag copy = blockEntityNbt.m_6426_();
                copy.m_128379_("keepPacked", true);
                pendingBlockEntitiesNbtPacked.put(blockPos, copy);
            }
            this.pendingBlockEntityNbtsPacked = pendingBlockEntitiesNbtPacked;
            HashSet<BlockPos> blockPos = new HashSet<BlockPos>(this.blockEntities.keySet());
            blockPos.addAll(this.pendingBlockEntityNbtsPacked.keySet());
            if (this.blockEntityPositions.size() != blockPos.size() && DEBUG) {
                LOGGER.warn("Block entities size mismatch! expected {} but got {}", (Object)this.blockEntityPositions.size(), (Object)blockPos.size());
            }
        }

        public void open() {
            if (!this.isOpen.compareAndSet(false, true)) {
                throw new IllegalStateException("Cannot use scope twice");
            }
        }

        private static final class CachedLightingView
        implements LayerLightEventListener {
            private static final DataLayer EMPTY = new DataLayer();
            private final LightLayer lightType;
            private final Map<SectionPos, DataLayer> cachedData = new Object2ObjectOpenHashMap();

            CachedLightingView(LevelLightEngine provider, ChunkPos pos, LightLayer type) {
                this.lightType = type;
                for (int i = provider.m_164447_(); i < provider.m_164448_(); ++i) {
                    SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)pos, (int)i);
                    DataLayer lighting = provider.m_75814_(type).m_8079_(sectionPos);
                    this.cachedData.put(sectionPos, lighting != null ? lighting.m_62569_() : null);
                }
            }

            public LightLayer getLightType() {
                return this.lightType;
            }

            public void m_7174_(BlockPos blockPos) {
                throw new UnsupportedOperationException();
            }

            public boolean m_75808_() {
                throw new UnsupportedOperationException();
            }

            public int m_9323_() {
                throw new UnsupportedOperationException();
            }

            public void m_6191_(SectionPos pos, boolean notReady) {
                throw new UnsupportedOperationException();
            }

            public void m_9335_(ChunkPos chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void m_142519_(ChunkPos chunkPos) {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public DataLayer m_8079_(SectionPos pos) {
                return this.cachedData.getOrDefault(pos, EMPTY);
            }

            public int m_7768_(BlockPos pos) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

