/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.mojang.datafixers.util.Pair;
import com.naterbobber.darkerdepths.data.tags.DDBiomeTagsProvider;
import com.naterbobber.darkerdepths.init.DDProcessorLists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DDStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"darkerdepths");
    public static final RegistryObject<StructureType<JigsawStructure>> DD_JIGSAW_TYPE = STRUCTURE_TYPES.register("dd_jigsaw", () -> () -> JigsawStructure.f_227604_);
    public static final ResourceKey<Structure> ROPE_MINE_FOREST = DDStructures.createStructureKey("rope_mine_forest");
    public static final ResourceKey<StructureSet> ROPE_MINE_FOREST_SET = DDStructures.createStructureSetKey("rope_mine_forest");
    public static final ResourceKey<StructureTemplatePool> ROPE_MINE_FOREST_POOL = DDStructures.createPoolKey("rope_mine_forest");
    public static final ResourceKey<Structure> ROPE_MINE_DESERT = DDStructures.createStructureKey("rope_mine_desert");
    public static final ResourceKey<StructureSet> ROPE_MINE_DESERT_SET = DDStructures.createStructureSetKey("rope_mine_desert");
    public static final ResourceKey<StructureTemplatePool> ROPE_MINE_DESERT_POOL = DDStructures.createPoolKey("rope_mine_desert");
    public static final ResourceKey<Structure> CATACOMBS = DDStructures.createStructureKey("catacombs");
    public static final ResourceKey<StructureSet> CATACOMBS_SET = DDStructures.createStructureSetKey("catacombs_set");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_STARTS_POOL = DDStructures.createPoolKey("catacombs/starts");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_POOL = DDStructures.createPoolKey("catacombs/halls");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_CENTER_EXTENSIONS_POOL = DDStructures.createPoolKey("catacombs/center_extensions");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_EXTENSIONS = DDStructures.createPoolKey("catacombs/extensions");

    public static void bootstrap(BootstapContext<Structure> context) {
        HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
        HolderGetter poolGetter = context.m_255420_(Registries.f_256948_);
        Structure.StructureSettings forestSettings = new Structure.StructureSettings((HolderSet)biomeGetter.m_254956_(DDBiomeTagsProvider.HAS_ROPE_MINE_FOREST), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.m_255272_(ROPE_MINE_FOREST, (Object)new JigsawStructure(forestSettings, (Holder)poolGetter.m_255043_(ROPE_MINE_FOREST_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80));
        Structure.StructureSettings desertSettings = new Structure.StructureSettings((HolderSet)biomeGetter.m_254956_(DDBiomeTagsProvider.HAS_ROPE_MINE_DESERT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.m_255272_(ROPE_MINE_DESERT, (Object)new JigsawStructure(desertSettings, (Holder)poolGetter.m_255043_(ROPE_MINE_DESERT_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-18)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80));
        Structure.StructureSettings catacombs = new Structure.StructureSettings((HolderSet)biomeGetter.m_254956_(DDBiomeTagsProvider.CATACOMBS), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(v -> v, v1 -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.VEGETAL_DECORATION, TerrainAdjustment.BURY);
        context.m_255272_(CATACOMBS, (Object)new JigsawStructure(catacombs, (Holder)poolGetter.m_255043_(CATACOMBS_STARTS_POOL), Optional.empty(), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10)), false, Optional.empty(), 116));
    }

    public static void bootstrapStructureSet(BootstapContext<StructureSet> context) {
        HolderGetter structureGetter = context.m_255420_(Registries.f_256944_);
        context.m_255272_(ROPE_MINE_FOREST_SET, (Object)new StructureSet((Holder)structureGetter.m_255043_(ROPE_MINE_FOREST), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 1234567890)));
        context.m_255272_(ROPE_MINE_DESERT_SET, (Object)new StructureSet((Holder)structureGetter.m_255043_(ROPE_MINE_DESERT), (StructurePlacement)new RandomSpreadStructurePlacement(28, 10, RandomSpreadType.LINEAR, 1234567891)));
        context.m_255272_(CATACOMBS_SET, (Object)new StructureSet((Holder)structureGetter.m_255043_(CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 20083232)));
    }

    public static void bootstrapTemplatePool(BootstapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPoolHolder = context.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_);
        HolderGetter processorList = context.m_255420_(Registries.f_257011_);
        Holder.Reference catacombsProcessor = processorList.m_255043_(DDProcessorLists.CATACOMBS_PROCESSOR);
        Holder.Reference ropeMineProcessor = processorList.m_255043_(DDProcessorLists.ROPE_MINES_PROCESSOR);
        context.m_255272_(ROPE_MINE_FOREST_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:rope_mine_forest", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.m_255272_(ROPE_MINE_DESERT_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:rope_mine_desert", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.m_255272_(CATACOMBS_STARTS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/center_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/center_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.m_255272_(CATACOMBS_CENTER_EXTENSIONS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
        context.m_255272_(CATACOMBS_HALLS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10))));
        context.m_255272_(CATACOMBS_HALLS_EXTENSIONS, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_7", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/room_8", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/treasure_room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/treasure_room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"darkerdepths:catacombs/treasure_room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
    }

    private static ResourceKey<Structure> createStructureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("darkerdepths", name));
    }

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("darkerdepths", name));
    }

    private static ResourceKey<StructureTemplatePool> createPoolKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("darkerdepths", name));
    }

    public static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("darkerdepths", name));
    }
}

