/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.config.DDConfigs;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.util.SuperchargeHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="darkerdepths")
public class ForgeBusEvents {
    @SubscribeEvent
    public static void onApplySupercharge(PlayerInteractEvent.RightClickItem event) {
        boolean isEligible;
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        boolean bl = isEligible = mainHandStack.m_41763_() || mainHandStack.m_41782_() && mainHandStack.m_41783_().m_128471_("Unbreakable");
        if (offHandStack.m_150930_(((Block)DDBlocks.CRYSTAL_MELON.get()).m_5456_()) && isEligible && !(mainHandStack.m_41720_() instanceof ArmorItem) && !ForgeBusEvents.isSuperchargedAndNotExpired(mainHandStack, level)) {
            SuperchargeHelper.applyUpgrades(mainHandStack, level);
            offHandStack.m_41774_(1);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.75f, 1.6f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        int digSpeedBuff = (Integer)DDConfigs.SUPERCHARGE_DIG_SPEED.get();
        int attackSpeedBuff = (Integer)DDConfigs.SUPERCHARGE_ATTACK_SPEED.get();
        int attackDamageBuff = (Integer)DDConfigs.SUPERCHARGE_ATTACK_DAMAGE.get();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null || !ForgeBusEvents.isSuperchargedAndNotExpired(stack, player.m_9236_())) {
            return;
        }
        event.getToolTip().add(Component.m_237119_());
        event.getToolTip().add(Component.m_237113_((String)"Supercharged:").m_130940_(ChatFormatting.AQUA));
        event.getToolTip().add(Component.m_237113_((String)(" +" + digSpeedBuff + "% Dig Speed")).m_130940_(ChatFormatting.GRAY));
        event.getToolTip().add(Component.m_237113_((String)(" +" + attackSpeedBuff + "% Attack Damage")).m_130940_(ChatFormatting.GRAY));
        event.getToolTip().add(Component.m_237113_((String)(" +" + attackDamageBuff + "% Attack Speed")).m_130940_(ChatFormatting.GRAY));
        if (((Boolean)DDConfigs.SUPERCHARGE_UNBREAKABLE.get()).booleanValue()) {
            event.getToolTip().add(Component.m_237113_((String)"Unbreakable").m_130940_(ChatFormatting.BLUE));
        }
        CompoundTag upgradeTag = stack.m_41783_().m_128469_("darkerdepths_upgrades");
        long expirationTick = upgradeTag.m_128454_("expiration_tick");
        long currentTime = player.m_9236_().m_46467_();
        long remainingTicks = expirationTick - currentTime;
        long remainingSeconds = remainingTicks / 20L;
        String timeFormatted = String.format("%02d:%02d", remainingSeconds / 60L, remainingSeconds % 60L);
        event.getToolTip().add(Component.m_237113_((String)("Time Remaining: " + timeFormatted)).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            Player player = event.player;
            Level level = player.m_9236_();
            ForgeBusEvents.isSuperchargedAndNotExpired(player.m_21205_(), level);
            ForgeBusEvents.isSuperchargedAndNotExpired(player.m_21206_(), level);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Level level;
        ItemStack heldItem = event.getEntity().m_21205_();
        if (ForgeBusEvents.isSuperchargedAndNotExpired(heldItem, level = event.getEntity().m_9236_())) {
            float currentSpeed = event.getNewSpeed();
            event.setNewSpeed(currentSpeed * (1.0f + (float)((Integer)DDConfigs.SUPERCHARGE_DIG_SPEED.get()).intValue() / 100.0f));
        }
    }

    private static boolean isSuperchargedAndNotExpired(ItemStack stack, Level level) {
        if (stack.m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("darkerdepths_upgrades")) {
            return false;
        }
        CompoundTag upgradeTag = stack.m_41783_().m_128469_("darkerdepths_upgrades");
        long expirationTick = upgradeTag.m_128454_("expiration_tick");
        if (level.m_46467_() >= expirationTick) {
            SuperchargeHelper.revertUpgrades(stack);
            return false;
        }
        return true;
    }
}

