/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.naterbobber.darkerdepths.client.DynamicLightHandler;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDMobEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientForgeEvents {
    private static float paranoiaFactor = 0.0f;
    private static final float TRANSITION_SECONDS = 1.5f;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        DynamicLightHandler.onClientTick(event);
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float ticks = 20.0f;
        float step = 1.0f / (1.5f * ticks);
        paranoiaFactor = player.m_21023_((MobEffect)DDMobEffects.PARANOIA.get()) ? (paranoiaFactor += step) : (paranoiaFactor -= step);
        paranoiaFactor = Math.max(0.0f, Math.min(1.0f, paranoiaFactor));
    }

    @SubscribeEvent
    public void onFogColor(ViewportEvent.ComputeFogColor event) {
        if (paranoiaFactor > 0.0f) {
            float normalRed = event.getRed();
            float normalGreen = event.getGreen();
            float normalBlue = event.getBlue();
            event.setRed(this.lerp(normalRed, 0.0f, paranoiaFactor));
            event.setGreen(this.lerp(normalGreen, 0.0f, paranoiaFactor));
            event.setBlue(this.lerp(normalBlue, 0.0f, paranoiaFactor));
        }
    }

    @SubscribeEvent
    public void onRenderFog(ViewportEvent.RenderFog event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_() || !player.m_21023_(MobEffects.f_19610_) && !player.m_21023_((MobEffect)DDMobEffects.PARANOIA.get())) {
            return;
        }
        boolean isParanoid = paranoiaFactor > 0.0f;
        float farPlaneMultiplier = 1.0f;
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        Item voidSoulTorch = (Item)DDItems.VOID_SOUL_TORCH.get();
        Item torch = Items.f_42000_;
        Item redstoneTorch = Items.f_41978_;
        Item soulTorch = Items.f_42053_;
        if (isParanoid) {
            int amplifier = this.getEffectAmplifier();
            float defaultFarPlane = Minecraft.m_91087_().f_91063_.m_109152_();
            float effectFarPlane = 15.0f - (float)amplifier * 15.0f;
            float effectNearPlane = -5.0f;
            float newFar = this.lerp(defaultFarPlane, effectFarPlane, paranoiaFactor);
            float newNear = this.lerp(defaultFarPlane, effectNearPlane, paranoiaFactor);
            event.setNearPlaneDistance(newNear);
            event.setFarPlaneDistance(newFar);
            event.setFogShape(FogShape.SPHERE);
            if (mainHandItem.m_150930_(voidSoulTorch) || offHandItem.m_150930_(voidSoulTorch)) {
                farPlaneMultiplier = 2.0f;
            } else if (mainHandItem.m_150930_(torch) || offHandItem.m_150930_(torch)) {
                farPlaneMultiplier = 1.4f;
            } else if (mainHandItem.m_150930_(redstoneTorch) || offHandItem.m_150930_(redstoneTorch)) {
                farPlaneMultiplier = 1.25f;
            } else if (mainHandItem.m_150930_(soulTorch) || offHandItem.m_150930_(soulTorch)) {
                farPlaneMultiplier = 0.7f;
            }
            event.setFarPlaneDistance(event.getFarPlaneDistance() * farPlaneMultiplier);
            event.setCanceled(true);
        }
        if (player.m_21023_(MobEffects.f_19610_)) {
            if (mainHandItem.m_150930_(voidSoulTorch) || offHandItem.m_150930_(voidSoulTorch)) {
                event.setFarPlaneDistance(event.getFarPlaneDistance() * 2.0f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onComputeFov(ViewportEvent.ComputeFov event) {
        if (paranoiaFactor > 0.0f) {
            double defaultFov = event.getFOV();
            int amplifier = this.getEffectAmplifier();
            double zoomedFov = defaultFov * (0.9 - (double)amplifier * 0.05);
            event.setFOV(this.lerp(defaultFov, zoomedFov, (double)paranoiaFactor));
        }
    }

    private int getEffectAmplifier() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_21023_((MobEffect)DDMobEffects.PARANOIA.get())) {
            return player.m_21124_((MobEffect)DDMobEffects.PARANOIA.get()).m_19564_();
        }
        return 0;
    }

    private float lerp(float start, float end, float factor) {
        return start + factor * (end - start);
    }

    private double lerp(double start, double end, double factor) {
        return start + factor * (end - start);
    }
}

