/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities.goals;

import com.naterbobber.darkerdepths.entities.goals.IDashable;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DashGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final double dashSpeed;
    private final double yBoost;
    private final double triggerDistanceSquare;
    private final int dashDurationTicks;
    private final int cooldownTicks;
    private final int prepareTicks;
    private int actionTicks;
    private int currentCooldown;

    public DashGoal(Mob mob, double dashSpeed, double yBoost, double triggerDistance, int dashDurationTicks, int cooldownTicks, int prepareTicks) {
        this.mob = mob;
        this.dashSpeed = dashSpeed;
        this.yBoost = yBoost;
        this.triggerDistanceSquare = triggerDistance * triggerDistance;
        this.dashDurationTicks = dashDurationTicks;
        this.cooldownTicks = cooldownTicks;
        this.prepareTicks = prepareTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
            return false;
        }
        this.target = this.mob.m_5448_();
        if (this.target == null) {
            return false;
        }
        return this.mob.m_20280_((Entity)this.target) > this.triggerDistanceSquare && this.mob.m_20096_();
    }

    public void m_8056_() {
        this.actionTicks = this.prepareTicks + this.dashDurationTicks;
        Mob mob = this.mob;
        if (mob instanceof IDashable) {
            IDashable dashable = (IDashable)mob;
            dashable.setPreparingToDash(true);
        }
    }

    public void m_8041_() {
        Mob mob = this.mob;
        if (mob instanceof IDashable) {
            IDashable dashable = (IDashable)mob;
            dashable.setPreparingToDash(false);
            dashable.setDashing(false);
        }
        this.currentCooldown = this.cooldownTicks;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        --this.actionTicks;
        if (this.actionTicks == this.dashDurationTicks) {
            Vec3 initialVelocity = this.mob.m_20182_().m_82505_(this.target.m_20182_()).m_82541_().m_82490_(this.dashSpeed);
            Vec3 finalVelocity = new Vec3(initialVelocity.m_7096_(), this.yBoost, initialVelocity.m_7094_());
            this.mob.m_20256_(finalVelocity);
            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
            Level level = this.mob.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.mob.m_20185_(), this.mob.m_20227_(0.5), this.mob.m_20189_(), 15, 0.3, 0.2, 0.3, 0.05);
            }
            if ((level = this.mob) instanceof IDashable) {
                IDashable dashable = (IDashable)level;
                dashable.setPreparingToDash(false);
                dashable.setDashing(true);
            }
        }
        if (this.target != null) {
            this.mob.m_21563_().m_148051_((Entity)this.target);
        }
    }

    public boolean m_8045_() {
        return this.actionTicks > 0 && this.target != null && this.target.m_6084_();
    }
}

