/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class PetrifiedBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(PetrifiedBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PetrifiedBoatEntity(EntityType<? extends Boat> boat, Level world) {
        super(boat, world);
        this.f_19850_ = true;
    }

    public PetrifiedBoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)DDEntityTypes.PETRIFIED_BOAT.get()), world);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)BoatType.PETRIFIED.ordinal());
    }

    public Item m_38369_() {
        return (Item)DDItems.PETRIFIED_BOAT.get();
    }

    public void setBoatType(BoatType type) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getBoatTypeDropItem().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Type", 8)) {
            this.setBoatType(BoatType.byName(tag.m_128461_("Type")));
        }
    }

    public BoatType getBoatTypeDropItem() {
        return BoatType.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum BoatType {
        PETRIFIED((Block)DDBlocks.PETRIFIED_PLANKS.get(), "petrified");

        private final String name;
        private final Block planks;

        private BoatType(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int p_38431_) {
            BoatType[] aboat$type = BoatType.values();
            if (p_38431_ < 0 || p_38431_ >= aboat$type.length) {
                p_38431_ = 0;
            }
            return aboat$type[p_38431_];
        }

        public static BoatType byName(String p_38433_) {
            BoatType[] aboat$type = BoatType.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].getName().equals(p_38433_)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }
}

