/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.effects;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ParanoiaEffect
extends MobEffect {
    private final Map<UUID, Integer> PARANOIA_COOLDOWNS = Maps.newHashMap();
    private final double SOUND_CHANCE = 0.0015f;
    private static final List<SoundEvent> PARANOIA_SOUNDS = List.of(SoundEvents.f_12450_, SoundEvents.f_12638_);

    public ParanoiaEffect() {
        super(MobEffectCategory.HARMFUL, 0x1A1A1A);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Vec3 soundDirection;
        int currentCooldown = this.PARANOIA_COOLDOWNS.getOrDefault(entity.m_20148_(), 0);
        super.m_6742_(entity, amplifier);
        if (currentCooldown > 0) {
            this.PARANOIA_COOLDOWNS.put(entity.m_20148_(), currentCooldown - 1);
            return;
        }
        RandomSource random = entity.m_217043_();
        if (random.m_188500_() > (double)0.0015f || entity.m_9236_().m_5776_()) {
            return;
        }
        double minRadius = 4.0;
        double maxRadius = 16.0;
        double radius = minRadius + random.m_188500_() * (maxRadius - minRadius);
        double angle = random.m_188500_() * 2.0 * Math.PI;
        double xOffset = Math.cos(angle) * radius;
        double zOffset = Math.sin(angle) * radius;
        Vec3 lookVector = entity.m_20154_();
        Vec3 lookDirection = new Vec3(lookVector.f_82479_, 0.0, lookVector.f_82481_).m_82541_();
        double dotProduct = lookDirection.m_82526_(soundDirection = new Vec3(xOffset, 0.0, zOffset).m_82541_());
        if (dotProduct > 0.0) {
            return;
        }
        SoundEvent randomSound = PARANOIA_SOUNDS.get(random.m_188503_(PARANOIA_SOUNDS.size()));
        double yOffset = -1.0 + random.m_188500_() * 2.0;
        double soundX = entity.m_20185_() + xOffset;
        double soundY = entity.m_20186_() + (double)entity.m_20192_() + yOffset;
        double soundZ = entity.m_20189_() + zOffset;
        entity.m_9236_().m_6263_(null, soundX, soundY, soundZ, randomSound, SoundSource.AMBIENT, 1.0f, 0.8f + random.m_188501_() * 0.4f);
        this.PARANOIA_COOLDOWNS.put(entity.m_20148_(), currentCooldown + 360 - amplifier * 60);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

