/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import com.naterbobber.darkerdepths.init.DDParticleTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoidSoulParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final float originalScale;
    private float rotation;
    private int lingeringTime;
    private boolean canBeBottled;

    protected VoidSoulParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lingeringTime = this.f_107225_ = 1200;
        this.canBeBottled = true;
        this.originalScale = this.f_107663_ = 0.3f + RANDOM.nextFloat() * 0.2f;
        this.f_172258_ = 0.98f;
        this.f_107226_ = -0.001f;
        this.f_107219_ = true;
    }

    public void m_5989_() {
        super.m_5989_();
        double time = (double)(this.f_107225_ - this.f_107224_) / (double)this.f_107225_;
        this.f_107216_ += Math.sin((double)this.f_107224_ * 0.1) * 0.001;
        this.f_107215_ += (RANDOM.nextDouble() - 0.5) * 0.001;
        this.f_107217_ += (RANDOM.nextDouble() - 0.5) * 0.001;
        float pulse = 1.0f + (float)Math.sin((double)this.f_107224_ * 0.2) * 0.1f;
        this.f_107663_ = this.originalScale * pulse;
        if ((float)this.f_107224_ > (float)this.f_107225_ * 0.8f) {
            this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / ((float)this.f_107225_ * 0.2f) * 0.8f;
        }
        this.checkForBottleInteraction();
    }

    private void checkForBottleInteraction() {
        if (!this.canBeBottled) {
            return;
        }
        List nearbyPlayers = this.f_107208_.m_45976_(Player.class, new AABB(this.f_107212_ - 2.0, this.f_107213_ - 2.0, this.f_107214_ - 2.0, this.f_107212_ + 2.0, this.f_107213_ + 2.0, this.f_107214_ + 2.0));
        for (Player player : nearbyPlayers) {
            double distance;
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() != Items.f_42590_ || !((distance = player.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_)) < 4.0)) continue;
            this.captureInBottle(player, heldItem);
            return;
        }
    }

    private void captureInBottle(Player player, ItemStack bottleStack) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        bottleStack.m_41774_(1);
        this.m_107274_();
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11770_, SoundSource.PLAYERS, 0.8f, 1.2f);
        VoidSoulHelper.spawnParticleEffect(player.m_9236_(), this.f_107212_, this.f_107213_, this.f_107214_, (ParticleOptions)ParticleTypes.f_123746_, 10, 0.5, 0.0, 0.05, 0.0);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public boolean canBeBottled() {
        return this.canBeBottled;
    }

    public void setCanBeBottled(boolean canBeBottled) {
        this.canBeBottled = canBeBottled;
    }

    public static class VoidSoulHelper {
        public static void spawnVoidSoulParticles(Level level, double x, double y, double z, int count) {
            VoidSoulHelper.spawnParticleEffect(level, x, y, z, (ParticleOptions)DDParticleTypes.VOID_SOUL.get(), count, 2.0, 0.05, 0.05, 0.05);
        }

        public static void spawnParticleEffect(Level level, double x, double y, double z, ParticleOptions particleType, int count, double spread, double velX, double velY, double velZ) {
            if (level.f_46443_) {
                for (int i = 0; i < count; ++i) {
                    double finalVelX;
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * spread;
                    double offsetY = (level.f_46441_.m_188500_() - 0.5) * spread;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * spread;
                    double d = finalVelX = velX == 0.0 ? 0.0 : (level.f_46441_.m_188500_() - 0.5) * velX;
                    double finalVelY = velY == 0.0 ? 0.0 : (velY > 0.01 ? velY : level.f_46441_.m_188500_() * velY);
                    double finalVelZ = velZ == 0.0 ? 0.0 : (level.f_46441_.m_188500_() - 0.5) * velZ;
                    level.m_7106_(particleType, x + offsetX, y + offsetY, z + offsetZ, finalVelX, finalVelY, finalVelZ);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VoidSoulFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public VoidSoulFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            VoidSoulParticle particle = new VoidSoulParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

