/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.api.DeathAnchorLocation;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDPoiTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeathAnchorBlock
extends Block {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public DeathAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)DDItems.VOID_SOUL_REQUIEM.get()) && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.m_5594_(null, blockPos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (player instanceof DeathAnchorLocation) {
                DeathAnchorLocation deathAnchorLocation = (DeathAnchorLocation)player;
                this.handleExistingDeathAnchor(level, blockPos, deathAnchorLocation);
                deathAnchorLocation.setDeathAnchorLocation(Optional.of(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)blockPos)));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, blockPos, player, hand, result);
    }

    private void handleExistingDeathAnchor(Level level, BlockPos current, DeathAnchorLocation deathAnchorLocation) {
        Optional<GlobalPos> deathAnchorLocation1 = deathAnchorLocation.getDeathAnchorLocation();
        if (deathAnchorLocation1.isPresent() && level instanceof ServerLevel) {
            ServerLevel newServer;
            ServerLevel serverLevel = (ServerLevel)level;
            GlobalPos globalPos = deathAnchorLocation1.get();
            ResourceKey resourcekey = globalPos.m_122640_();
            ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
            BlockPos pos = globalPos.m_122646_();
            if (pos.equals((Object)current)) {
                return;
            }
            if (key != null && (newServer = serverLevel.m_7654_().m_129880_(resourcekey)) != null && newServer.m_8904_().m_217874_(key, pos)) {
                newServer.m_186460_(pos, (Block)DDBlocks.DEATH_ANCHOR.get(), 2);
                newServer.m_7731_(pos, (BlockState)((Block)DDBlocks.DEATH_ANCHOR.get()).m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        serverLevel.m_5594_(null, blockPos, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

