/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.mixin;

import com.moepus.biomespy.biome.BiomeEnvelopeSelector;
import com.moepus.biomespy.mixin.MultiNoiseBiomeSourceAccessor;
import com.moepus.biomespy.mixin.StructureCheckAccessor;
import com.moepus.biomespy.mixin.StructureManagerAccessor;
import com.moepus.biomespy.mixin.StructurePlacementAccessor;
import com.moepus.biomespy.structure.StructureChecker;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    @Shadow
    @Final
    protected BiomeSource f_62137_;

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;IIIZJLnet/minecraft/world/level/levelgen/structure/placement/RandomSpreadStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getNearestGeneratedStructure(Set<Holder<Structure>> pStructureHoldersSet, LevelReader pLevel, StructureManager pStructureManager, int pX, int pY, int pZ, boolean pSkipKnownStructures, long pSeed, RandomSpreadStructurePlacement pSpreadPlacement, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        BiomeSource biomeSource = ((StructureCheckAccessor)((StructureManagerAccessor)pStructureManager).getStructureCheck()).getBiomeSource();
        if (!(biomeSource instanceof MultiNoiseBiomeSource)) {
            return;
        }
        cir.cancel();
        int spacing = pSpreadPlacement.m_205003_();
        Climate.ParameterList<Holder<Biome>> parameters = ((MultiNoiseBiomeSourceAccessor)biomeSource).invokeParameters();
        HashMap<Holder<Structure>, BiomeEnvelopeSelector> structureBiome = new HashMap<Holder<Structure>, BiomeEnvelopeSelector>();
        for (Holder<Structure> structure : pStructureHoldersSet) {
            structureBiome.put(structure, new BiomeEnvelopeSelector(((Structure)structure.m_203334_()).m_226559_().m_203614_().toList(), parameters, (MultiNoiseBiomeSource)biomeSource));
        }
        for (int j = -pZ; j <= pZ; ++j) {
            boolean flag = j == -pZ || j == pZ;
            for (int k = -pZ; k <= pZ; ++k) {
                Pair<BlockPos, Holder<Structure>> pair;
                boolean flag1;
                boolean bl = flag1 = k == -pZ || k == pZ;
                if (!flag && !flag1) continue;
                int regionX = pX + spacing * j;
                int regionZ = pY + spacing * k;
                ChunkPos chunkpos = pSpreadPlacement.m_227008_(pSeed, regionX, regionZ);
                StructurePlacementAccessor placement = (StructurePlacementAccessor)pSpreadPlacement;
                if (placement.getFrequency() < 1.0f && !placement.getFrequencyReductionMethod().m_227119_(pSeed, placement.getSalt(), chunkpos.f_45578_, chunkpos.f_45579_, placement.getFrequency()) || (pair = StructureChecker.getStructureGeneratingAt(structureBiome, pLevel, pStructureManager, pSkipKnownStructures, (StructurePlacement)pSpreadPlacement, chunkpos, parameters)) == null) continue;
                cir.setReturnValue(pair);
                return;
            }
        }
        cir.setReturnValue(null);
    }
}

