/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.biome;

import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;

public final class BiomeEnvelope {
    public boolean impossible = false;
    public long tMin = Long.MAX_VALUE;
    public long tMax = Long.MIN_VALUE;
    public long hMin = Long.MAX_VALUE;
    public long hMax = Long.MIN_VALUE;
    public long cMin = Long.MAX_VALUE;
    public long cMax = Long.MIN_VALUE;
    public long eMin = Long.MAX_VALUE;
    public long eMax = Long.MIN_VALUE;
    public long wMin = Long.MAX_VALUE;
    public long wMax = Long.MIN_VALUE;

    public void add(Climate.ParameterPoint pp) {
        Climate.Parameter T = pp.f_186863_();
        this.tMin = Math.min(this.tMin, T.f_186813_());
        this.tMax = Math.max(this.tMax, T.f_186814_());
        Climate.Parameter H = pp.f_186864_();
        this.hMin = Math.min(this.hMin, H.f_186813_());
        this.hMax = Math.max(this.hMax, H.f_186814_());
        Climate.Parameter C = pp.f_186865_();
        this.cMin = Math.min(this.cMin, C.f_186813_());
        this.cMax = Math.max(this.cMax, C.f_186814_());
        Climate.Parameter E = pp.f_186866_();
        this.eMin = Math.min(this.eMin, E.f_186813_());
        this.eMax = Math.max(this.eMax, E.f_186814_());
        Climate.Parameter W = pp.f_186868_();
        this.wMin = Math.min(this.wMin, W.f_186813_());
        this.wMax = Math.max(this.wMax, W.f_186814_());
    }

    public void add(BiomeEnvelope other) {
        this.tMin = Math.min(this.tMin, other.tMin);
        this.tMax = Math.max(this.tMax, other.tMax);
        this.hMin = Math.min(this.hMin, other.hMin);
        this.hMax = Math.max(this.hMax, other.hMax);
        this.cMin = Math.min(this.cMin, other.cMin);
        this.cMax = Math.max(this.cMax, other.cMax);
        this.eMin = Math.min(this.eMin, other.eMin);
        this.eMax = Math.max(this.eMax, other.eMax);
        this.wMin = Math.min(this.wMin, other.wMin);
        this.wMax = Math.max(this.wMax, other.wMax);
    }

    public String toString() {
        if (this.impossible) {
            return "BiomeEnvelope{impossible}";
        }
        return "BiomeEnvelope{T=[" + this.tMin + "," + this.tMax + "],H=[" + this.hMin + "," + this.hMax + "],C=[" + this.cMin + "," + this.cMax + "],E=[" + this.eMin + "," + this.eMax + "],W=[" + this.wMin + "," + this.wMax + "]}";
    }

    public boolean matches(Climate.Sampler sampler, DensityFunction.SinglePointContext ctx) {
        long e;
        long c;
        long w;
        long h;
        long t;
        if (this.tMin <= this.tMax && this.tMin + 20000L > this.tMax && ((t = Climate.m_186779_((float)((float)sampler.f_207845_().m_207386_((DensityFunction.FunctionContext)ctx)))) < this.tMin || t > this.tMax)) {
            return false;
        }
        if (this.hMin <= this.hMax && this.hMin + 20000L > this.hMax && ((h = Climate.m_186779_((float)((float)sampler.f_207846_().m_207386_((DensityFunction.FunctionContext)ctx)))) < this.hMin || h > this.hMax)) {
            return false;
        }
        if (this.wMin <= this.wMax && this.wMin + 20000L > this.wMax && ((w = Climate.m_186779_((float)((float)sampler.f_207850_().m_207386_((DensityFunction.FunctionContext)ctx)))) < this.wMin || w > this.wMax)) {
            return false;
        }
        if (this.cMin <= this.cMax && this.cMin + 20000L > this.cMax && ((c = Climate.m_186779_((float)((float)sampler.f_207847_().m_207386_((DensityFunction.FunctionContext)ctx)))) < this.cMin || c > this.cMax)) {
            return false;
        }
        return this.eMin > this.eMax || this.eMin + 20000L <= this.eMax || (e = Climate.m_186779_((float)((float)sampler.f_207848_().m_207386_((DensityFunction.FunctionContext)ctx)))) >= this.eMin && e <= this.eMax;
    }

    boolean isValid() {
        return this.tMin != this.tMax && this.hMin != this.hMax && this.cMin != this.cMax && this.eMin != this.eMax && this.wMin != this.wMax;
    }
}

