/*
 * Decompiled with CFR 0.152.
 */
package railOptimization;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import railOptimization.PoweredRailBlockInvoker;

public class RailLogic_Common {
    private static final Direction[] EAST_WEST_DIR = new Direction[]{Direction.WEST, Direction.EAST};
    private static final Direction[] NORTH_SOUTH_DIR = new Direction[]{Direction.SOUTH, Direction.NORTH};
    private static final int UPDATE_FORCE_PLACE = 82;
    public static int RAIL_POWER_LIMIT = 8;

    public static void giveShapeUpdate(Level level, BlockState state, BlockPos pos, BlockPos fromPos, Direction direction) {
        BlockState oldState = level.m_8055_(pos);
        Block.m_49908_((BlockState)oldState, (BlockState)oldState.m_60728_(direction.m_122424_(), state, (LevelAccessor)level, pos, fromPos), (LevelAccessor)level, (BlockPos)pos, (int)2, (int)0);
    }

    public static void setRailPowerLimit(int powerLimit) {
        RAIL_POWER_LIMIT = powerLimit;
    }

    public static void customUpdateState(PoweredRailBlock self, BlockState state, Level level, BlockPos pos) {
        boolean shouldBePowered;
        boolean bl = shouldBePowered = level.m_276867_(pos) || ((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(level, pos, state, true, 0) || ((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(level, pos, state, false, 0);
        if (shouldBePowered != (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)) {
            RailShape railShape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
            if (railShape.m_61745_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
                level.m_46590_(pos.m_7495_(), (Block)self, Direction.UP);
                level.m_46590_(pos.m_7494_(), (Block)self, Direction.DOWN);
            } else if (shouldBePowered) {
                RailLogic_Common.powerLane(self, level, pos, state, railShape);
            } else {
                RailLogic_Common.dePowerLane(self, level, pos, state, railShape);
            }
        }
    }

    public static boolean findPoweredRailSignalFaster(PoweredRailBlock self, Level world, BlockPos pos, boolean bl, int distance, RailShape shape, HashMap<BlockPos, Boolean> checkedPos) {
        boolean speedCheck;
        BlockState blockState = world.m_8055_(pos);
        boolean bl2 = speedCheck = checkedPos.containsKey(pos) && checkedPos.get(pos) != false;
        if (speedCheck) {
            return world.m_276867_(pos) || RailLogic_Common.findPoweredRailSignalFaster(self, world, pos, blockState, bl, distance + 1, checkedPos);
        }
        if (blockState.m_60713_((Block)self)) {
            RailShape railShape = (RailShape)blockState.m_61143_((Property)PoweredRailBlock.f_55214_);
            if (shape == RailShape.EAST_WEST && (railShape == RailShape.NORTH_SOUTH || railShape == RailShape.ASCENDING_NORTH || railShape == RailShape.ASCENDING_SOUTH) || shape == RailShape.NORTH_SOUTH && (railShape == RailShape.EAST_WEST || railShape == RailShape.ASCENDING_EAST || railShape == RailShape.ASCENDING_WEST)) {
                return false;
            }
            if (((Boolean)blockState.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
                return world.m_276867_(pos) || RailLogic_Common.findPoweredRailSignalFaster(self, world, pos, blockState, bl, distance + 1, checkedPos);
            }
            return false;
        }
        return false;
    }

    public static boolean findPoweredRailSignalFaster(PoweredRailBlock self, Level level, BlockPos pos, BlockState state, boolean bl, int distance, HashMap<BlockPos, Boolean> checkedPos) {
        if (distance >= RAIL_POWER_LIMIT - 1) {
            return false;
        }
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        boolean bl2 = true;
        RailShape railShape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
        switch (railShape.ordinal()) {
            case 0: {
                if (bl) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (bl) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (bl) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    bl2 = false;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case 3: {
                if (bl) {
                    --i;
                    ++j;
                    bl2 = false;
                } else {
                    ++i;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case 4: {
                if (bl) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    bl2 = false;
                }
                railShape = RailShape.NORTH_SOUTH;
                break;
            }
            case 5: {
                if (bl) {
                    ++k;
                    ++j;
                    bl2 = false;
                } else {
                    --k;
                }
                railShape = RailShape.NORTH_SOUTH;
            }
        }
        return RailLogic_Common.findPoweredRailSignalFaster(self, level, new BlockPos(i, j, k), bl, distance, railShape, checkedPos) || bl2 && RailLogic_Common.findPoweredRailSignalFaster(self, level, new BlockPos(i, j - 1, k), bl, distance, railShape, checkedPos);
    }

    public static void powerLane(PoweredRailBlock self, Level world, BlockPos pos, BlockState mainState, RailShape railShape) {
        world.m_7731_(pos, (BlockState)mainState.m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 82);
        HashMap<BlockPos, Boolean> checkedPos = new HashMap<BlockPos, Boolean>();
        checkedPos.put(pos, true);
        int[] count = new int[2];
        if (railShape == RailShape.NORTH_SOUTH) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                RailLogic_Common.setRailPositionsPower(self, world, pos, checkedPos, count, i, NORTH_SOUTH_DIR[i]);
            }
            RailLogic_Common.updateRails(self, false, world, pos, mainState, count);
        } else if (railShape == RailShape.EAST_WEST) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                RailLogic_Common.setRailPositionsPower(self, world, pos, checkedPos, count, i, EAST_WEST_DIR[i]);
            }
            RailLogic_Common.updateRails(self, true, world, pos, mainState, count);
        }
    }

    public static void dePowerLane(PoweredRailBlock self, Level world, BlockPos pos, BlockState mainState, RailShape railShape) {
        world.m_7731_(pos, (BlockState)mainState.m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(false)), 82);
        int[] count = new int[2];
        if (railShape == RailShape.NORTH_SOUTH) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                RailLogic_Common.setRailPositionsDePower(self, world, pos, count, i, NORTH_SOUTH_DIR[i]);
            }
            RailLogic_Common.updateRails(self, false, world, pos, mainState, count);
        } else if (railShape == RailShape.EAST_WEST) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                RailLogic_Common.setRailPositionsDePower(self, world, pos, count, i, EAST_WEST_DIR[i]);
            }
            RailLogic_Common.updateRails(self, true, world, pos, mainState, count);
        }
    }

    private static void setRailPositionsPower(PoweredRailBlock self, Level world, BlockPos pos, HashMap<BlockPos, Boolean> checkedPos, int[] count, int i, Direction dir) {
        for (int z = 1; z < RAIL_POWER_LIMIT; ++z) {
            BlockPos newPos = pos.m_5484_(dir, z);
            BlockState state = world.m_8055_(newPos);
            if (checkedPos.containsKey(newPos)) {
                if (!checkedPos.get(newPos).booleanValue()) break;
                int n = i;
                count[n] = count[n] + 1;
                continue;
            }
            if (!state.m_60713_((Block)self) || ((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue() || !world.m_276867_(newPos) && !RailLogic_Common.findPoweredRailSignalFaster(self, world, newPos, state, true, 0, checkedPos) && !RailLogic_Common.findPoweredRailSignalFaster(self, world, newPos, state, false, 0, checkedPos)) {
                checkedPos.put(newPos, false);
                break;
            }
            checkedPos.put(newPos, true);
            world.m_7731_(newPos, (BlockState)state.m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private static void setRailPositionsDePower(PoweredRailBlock self, Level world, BlockPos pos, int[] count, int i, Direction dir) {
        BlockPos newPos;
        BlockState state;
        for (int z = 1; z < RAIL_POWER_LIMIT && (state = world.m_8055_(newPos = pos.m_5484_(dir, z))).m_60713_((Block)self) && ((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue() && !world.m_276867_(newPos) && !((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(world, newPos, state, true, 0) && !((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(world, newPos, state, false, 0); ++z) {
            world.m_7731_(newPos, (BlockState)state.m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(false)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private static void shapeUpdateEnd(PoweredRailBlock self, Level world, BlockPos pos, BlockState mainState, int endPos, Direction direction, int currentPos, BlockPos blockPos) {
        if (currentPos == endPos) {
            BlockPos newPos = pos.m_5484_(direction, currentPos + 1);
            RailLogic_Common.giveShapeUpdate(world, mainState, newPos, pos, direction);
            BlockState state = world.m_8055_(blockPos);
            if (state.m_60713_((Block)self) && ((RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_)).m_61745_()) {
                RailLogic_Common.giveShapeUpdate(world, mainState, newPos.m_7494_(), pos, direction);
            }
        }
    }

    private static void neighborUpdateEnd(PoweredRailBlock self, Level world, BlockPos pos, int endPos, Direction direction, Block block, int currentPos, BlockPos blockPos) {
        if (currentPos == endPos) {
            BlockPos newPos = pos.m_5484_(direction, currentPos + 1);
            world.m_46586_(newPos, block, pos);
            BlockState state = world.m_8055_(blockPos);
            if (state.m_60713_((Block)self) && ((RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_)).m_61745_()) {
                world.m_46586_(newPos.m_7494_(), block, blockPos);
            }
        }
    }

    private static void updateRailsSectionEastWestShape(PoweredRailBlock self, Level world, BlockPos pos, int c, BlockState mainState, Direction dir, int[] count, int countAmt) {
        BlockPos pos1 = pos.m_5484_(dir, c);
        if (c == 0 && count[1] == 0) {
            RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_121945_(dir.m_122424_()), pos, dir.m_122424_());
        }
        RailLogic_Common.shapeUpdateEnd(self, world, pos, mainState, countAmt, dir, c, pos1);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_7495_(), pos, Direction.DOWN);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_7494_(), pos, Direction.UP);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_122012_(), pos, Direction.NORTH);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_122019_(), pos, Direction.SOUTH);
    }

    private static void updateRailsSectionNorthSouthShape(PoweredRailBlock self, Level world, BlockPos pos, int c, BlockState mainState, Direction dir, int[] count, int countAmt) {
        BlockPos pos1 = pos.m_5484_(dir, c);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_122024_(), pos, Direction.WEST);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_122029_(), pos, Direction.EAST);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_7495_(), pos, Direction.DOWN);
        RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_7494_(), pos, Direction.UP);
        RailLogic_Common.shapeUpdateEnd(self, world, pos, mainState, countAmt, dir, c, pos1);
        if (c == 0 && count[1] == 0) {
            RailLogic_Common.giveShapeUpdate(world, mainState, pos1.m_121945_(dir.m_122424_()), pos, dir.m_122424_());
        }
    }

    private static void updateRails(PoweredRailBlock self, boolean eastWest, Level world, BlockPos pos, BlockState mainState, int[] count) {
        if (eastWest) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                Direction dir = EAST_WEST_DIR[i];
                Block block = mainState.m_60734_();
                for (c = countAmt; c >= i; --c) {
                    BlockPos p = pos.m_5484_(dir, c);
                    if (c == 0 && count[1] == 0) {
                        world.m_46586_(p.m_121945_(dir.m_122424_()), block, pos);
                    }
                    RailLogic_Common.neighborUpdateEnd(self, world, pos, countAmt, dir, block, c, p);
                    world.m_46586_(p.m_7495_(), block, pos);
                    world.m_46586_(p.m_7494_(), block, pos);
                    world.m_46586_(p.m_122012_(), block, pos);
                    world.m_46586_(p.m_122019_(), block, pos);
                    BlockPos pos2 = pos.m_5484_(dir, c).m_7495_();
                    world.m_46586_(pos2.m_7495_(), block, pos);
                    world.m_46586_(pos2.m_122012_(), block, pos);
                    world.m_46586_(pos2.m_122019_(), block, pos);
                    if (c == countAmt) {
                        world.m_46586_(pos.m_5484_(dir, c + 1).m_7495_(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.m_46586_(p.m_121945_(dir.m_122424_()).m_7495_(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    RailLogic_Common.updateRailsSectionEastWestShape(self, world, pos, c, mainState, dir, count, countAmt);
                }
            }
        } else {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                Direction dir = NORTH_SOUTH_DIR[i];
                Block block = mainState.m_60734_();
                for (c = countAmt; c >= i; --c) {
                    BlockPos p = pos.m_5484_(dir, c);
                    world.m_46586_(p.m_122024_(), block, pos);
                    world.m_46586_(p.m_122029_(), block, pos);
                    world.m_46586_(p.m_7495_(), block, pos);
                    world.m_46586_(p.m_7494_(), block, pos);
                    RailLogic_Common.neighborUpdateEnd(self, world, pos, countAmt, dir, block, c, p);
                    if (c == 0 && count[1] == 0) {
                        world.m_46586_(p.m_121945_(dir.m_122424_()), block, pos);
                    }
                    BlockPos pos2 = pos.m_5484_(dir, c).m_7495_();
                    world.m_46586_(pos2.m_122024_(), block, pos);
                    world.m_46586_(pos2.m_122029_(), block, pos);
                    world.m_46586_(pos2.m_7495_(), block, pos);
                    if (c == countAmt) {
                        world.m_46586_(pos.m_5484_(dir, c + 1).m_7495_(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.m_46586_(p.m_121945_(dir.m_122424_()).m_7495_(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    RailLogic_Common.updateRailsSectionNorthSouthShape(self, world, pos, c, mainState, dir, count, countAmt);
                }
            }
        }
    }
}

