/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.terramity.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class PrismSolutionFluidType
extends FluidType {
    public PrismSolutionFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).motionScale(0.0105).lightLevel(15).density(8000).viscosity(8000).canConvertToSource(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.bucket.empty_lava"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("terramity:block/prism_solution");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("terramity:block/prism_solution_flow");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.8901961f, 0.50980395f, 0.9254902f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                Entity entity = camera.m_90592_();
                Level world = entity.m_9236_();
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)12.0f);
            }
        });
    }
}

