/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.worker;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.NewWayPointPacket;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;

public abstract class StructureSearchWorker<T extends StructurePlacement>
implements WorldWorkerManager.IWorker {
    protected String managerId;
    protected ServerLevel level;
    protected Player player;
    protected ItemStack stack;
    protected BlockPos startPos;
    protected BlockPos currentPos;
    protected T placement;
    protected List<Structure> structureSet;
    protected int samples;
    protected boolean finished;
    protected int lastRadiusThreshold;
    protected List<Pair<UUID, ChunkPos>> foundChunks;

    public StructureSearchWorker(ServerLevel level, Player player, ItemStack stack, BlockPos startPos, T placement, List<Structure> structureSet, String managerId, List<Pair<UUID, ChunkPos>> foundChunks) {
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.startPos = startPos;
        this.structureSet = structureSet;
        this.placement = placement;
        this.managerId = managerId;
        this.foundChunks = foundChunks;
        this.currentPos = startPos;
        this.samples = 0;
        this.finished = !level.m_7654_().m_129910_().m_246337_().m_247749_();
    }

    public void start() {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            if ((Integer)ConfigHandler.GENERAL.maxRadius.get() > 0) {
                ExplorersCompass.LOGGER.info("SearchWorkerManager {}: {} starting with {}{} max samples", (Object)this.managerId, (Object)this.getName(), this.shouldLogRadius() ? ConfigHandler.GENERAL.maxRadius.get() + " max radius, " : "", ConfigHandler.GENERAL.maxSamples.get());
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.fail();
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() < (Integer)ConfigHandler.GENERAL.maxRadius.get() && this.samples < (Integer)ConfigHandler.GENERAL.maxSamples.get();
    }

    public boolean doWork() {
        int radius = this.getRadius();
        if (radius > 250 && radius / 250 > this.lastRadiusThreshold) {
            if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
                ((ExplorersCompassItem)this.stack.m_41720_()).setSearchRadius(this.stack, this.roundRadius(radius), this.player);
            }
            this.lastRadiusThreshold = radius / 250;
        }
        return false;
    }

    protected Pair<BlockPos, Structure> getStructureGeneratingAt(ChunkPos chunkPos) {
        if (this.foundChunks.contains(Pair.of((Object)this.player.m_20148_(), (Object)chunkPos))) {
            return null;
        }
        for (Structure structure : this.structureSet) {
            StructureCheckResult result = this.level.m_215010_().m_220473_(chunkPos, structure, false);
            if (result == StructureCheckResult.START_NOT_PRESENT) continue;
            if (result == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)this.placement.m_227039_(chunkPos), (Object)structure);
            }
            ChunkAccess chunkAccess = this.level.m_46819_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_);
            StructureStart structureStart = this.level.m_215010_().m_220512_(SectionPos.m_175562_((ChunkAccess)chunkAccess), structure, (StructureAccess)chunkAccess);
            if (structureStart == null || !structureStart.m_73603_()) continue;
            return Pair.of((Object)this.placement.m_227039_(structureStart.m_163625_()), (Object)structure);
        }
        return null;
    }

    protected void succeed(BlockPos pos, Structure structure) {
        Item item;
        ExplorersCompass.LOGGER.info("SearchWorkerManager {}: {} succeeded with {}{} samples", (Object)this.managerId, (Object)this.getName(), this.shouldLogRadius() ? this.getRadius() + " radius, " : "", (Object)this.samples);
        if (!this.stack.m_41619_() && (item = this.stack.m_41720_()) instanceof ExplorersCompassItem) {
            Player player;
            ExplorersCompassItem compass = (ExplorersCompassItem)item;
            compass.succeed(this.stack, StructureUtils.getKeyForStructure(this.level, structure), pos.m_123341_(), pos.m_123343_(), this.samples, (Boolean)ConfigHandler.GENERAL.displayCoordinates.get());
            if (ModList.get().isLoaded("xaerominimap") && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ExplorersCompass.network.sendTo((Object)new NewWayPointPacket(pos.m_123341_(), pos.m_123343_()), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            ExplorersCompass.LOGGER.error("SearchWorkerManager {}: {} found invalid compass after successful search", (Object)this.managerId, (Object)this.getName());
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        this.foundChunks.add((Pair<UUID, ChunkPos>)Pair.of((Object)this.player.m_20148_(), (Object)chunkPos));
        this.finished = true;
    }

    protected void fail() {
        ExplorersCompass.LOGGER.info("SearchWorkerManager {}: {} failed with {}{} samples", (Object)this.managerId, (Object)this.getName(), this.shouldLogRadius() ? this.getRadius() + " radius, " : "", (Object)this.samples);
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            ((ExplorersCompassItem)this.stack.m_41720_()).fail(this.stack, this.roundRadius(this.getRadius()), this.samples);
        } else {
            ExplorersCompass.LOGGER.error("SearchWorkerManager {}: {} found invalid compass after failed search", (Object)this.managerId, (Object)this.getName());
        }
        if (((Boolean)ConfigHandler.GENERAL.cleanCache.get()).booleanValue()) {
            this.foundChunks.removeIf(pair -> ((UUID)pair.getFirst()).equals(this.player.m_20148_()));
        }
        this.finished = true;
    }

    public void stop() {
        ExplorersCompass.LOGGER.info("SearchWorkerManager {}: {} stopped with {}{} samples", (Object)this.managerId, (Object)this.getName(), this.shouldLogRadius() ? this.getRadius() + " radius, " : "", (Object)this.samples);
        this.finished = true;
    }

    protected int getRadius() {
        return StructureUtils.getHorizontalDistanceToLocation(this.startPos, this.currentPos.m_123341_(), this.currentPos.m_123343_());
    }

    protected int roundRadius(int radius) {
        return radius / 250 * 250;
    }

    protected abstract String getName();

    protected abstract boolean shouldLogRadius();
}

