/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.worker;

import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.chaosthedude.explorerscompass.worker.ConcentricRingsSearchWorker;
import com.chaosthedude.explorerscompass.worker.GenericSearchWorker;
import com.chaosthedude.explorerscompass.worker.RandomSpreadSearchWorker;
import com.chaosthedude.explorerscompass.worker.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.apache.commons.lang3.RandomStringUtils;

public class SearchWorkerManager {
    private final String id = RandomStringUtils.random((int)8, (String)"0123456789abcdef");
    private final List<StructureSearchWorker<?>> workers = new ArrayList();
    public static List<Pair<UUID, ChunkPos>> foundChunks;

    public SearchWorkerManager() {
        foundChunks = new ArrayList<Pair<UUID, ChunkPos>>();
    }

    public void createWorkers(ServerLevel level, Player player, ItemStack stack, List<Structure> structures, BlockPos startPos) {
        this.workers.clear();
        Object2ObjectArrayMap placementToStructuresMap = new Object2ObjectArrayMap();
        for (Structure structure : structures) {
            for (StructurePlacement structureplacement : level.m_7726_().m_255415_().m_255260_(Objects.requireNonNull(StructureUtils.getHolderForStructure(level, structure)))) {
                placementToStructuresMap.computeIfAbsent(structureplacement, holderSet -> new ObjectArrayList()).add(structure);
            }
        }
        for (Map.Entry entry : placementToStructuresMap.entrySet()) {
            StructurePlacement placement = (StructurePlacement)entry.getKey();
            if (placement instanceof ConcentricRingsStructurePlacement) {
                this.workers.add(new ConcentricRingsSearchWorker(level, player, stack, startPos, (ConcentricRingsStructurePlacement)placement, (List<Structure>)((List)entry.getValue()), this.id, foundChunks));
                continue;
            }
            if (placement instanceof RandomSpreadStructurePlacement) {
                this.workers.add(new RandomSpreadSearchWorker(level, player, stack, startPos, (RandomSpreadStructurePlacement)placement, (List<Structure>)((List)entry.getValue()), this.id, foundChunks));
                continue;
            }
            this.workers.add(new GenericSearchWorker(level, player, stack, startPos, placement, (List<Structure>)((List)entry.getValue()), this.id, foundChunks));
        }
    }

    public boolean start() {
        if (!this.workers.isEmpty()) {
            this.workers.get(0).start();
            return true;
        }
        return false;
    }

    public void pop() {
        if (!this.workers.isEmpty()) {
            this.workers.remove(0);
        }
    }

    public void stop() {
        for (StructureSearchWorker<?> worker : this.workers) {
            worker.stop();
        }
    }

    public void clear() {
        this.workers.clear();
    }
}

