/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.worker;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.worker.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class GenericSearchWorker
extends StructureSearchWorker<StructurePlacement> {
    public int chunkX;
    public int chunkZ;
    public int length;
    public double nextLength;
    public Direction direction;

    public GenericSearchWorker(ServerLevel level, Player player, ItemStack stack, BlockPos startPos, StructurePlacement placement, List<Structure> structureSet, String managerId, List<Pair<UUID, ChunkPos>> foundChunks) {
        super(level, player, stack, startPos, placement, structureSet, managerId, foundChunks);
        this.chunkX = startPos.m_123341_() >> 4;
        this.chunkZ = startPos.m_123343_() >> 4;
        this.nextLength = 1.0;
        this.length = 0;
        this.direction = Direction.UP;
    }

    @Override
    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                --this.chunkZ;
            } else if (this.direction == Direction.EAST) {
                ++this.chunkX;
            } else if (this.direction == Direction.SOUTH) {
                ++this.chunkZ;
            } else if (this.direction == Direction.WEST) {
                --this.chunkX;
            }
            ChunkPos chunkPos = new ChunkPos(this.chunkX, this.chunkZ);
            this.currentPos = new BlockPos(SectionPos.m_175554_((int)chunkPos.f_45578_, (int)8), 0, SectionPos.m_175554_((int)chunkPos.f_45579_, (int)8));
            Pair<BlockPos, Structure> pair = this.getStructureGeneratingAt(chunkPos);
            if (pair != null) {
                this.succeed((BlockPos)pair.getFirst(), (Structure)pair.getSecond());
            }
            ++this.samples;
            ++this.length;
            if (this.length >= (int)this.nextLength) {
                if (this.direction != Direction.UP) {
                    this.nextLength += 0.5;
                    this.direction = this.direction.m_122427_();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 250 && radius / 250 > this.lastRadiusThreshold) {
                if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
                    ((ExplorersCompassItem)this.stack.m_41720_()).setSearchRadius(this.stack, this.roundRadius(radius), this.player);
                }
                this.lastRadiusThreshold = radius / 250;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        if (!this.finished) {
            this.fail();
        }
        return false;
    }

    @Override
    protected String getName() {
        return "GenericSearchWorker";
    }

    @Override
    public boolean shouldLogRadius() {
        return true;
    }
}

